/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class SearchPluginImages {
    private static final ImageRegistry PLUGIN_REGISTRY = SearchPlugin.getDefault().getImageRegistry();
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    public static final String T_OBJ = "obj16/";
    public static final String T_WIZBAN = "wizban/";
    public static final String T_LCL = "lcl16/";
    public static final String T_TOOL = "tool16/";
    public static final String T_EVIEW = "eview16/";
    private static final String NAME_PREFIX = "org.eclipse.search.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.search.ui.".length();
    public static final String IMG_TOOL_SEARCH = "org.eclipse.search.ui.search.png";
    public static final String IMG_LCL_REFRESH = "org.eclipse.search.ui.refresh.png";
    public static final String IMG_LCL_PIN_VIEW = "org.eclipse.search.ui.pin_view.png";
    public static final String IMG_LCL_SEARCH_REM = "org.eclipse.search.ui.search_rem.png";
    public static final String IMG_LCL_SEARCH_REM_ALL = "org.eclipse.search.ui.search_remall.png";
    public static final String IMG_LCL_SEARCH_NEXT = "org.eclipse.search.ui.search_next.png";
    public static final String IMG_LCL_SEARCH_PREV = "org.eclipse.search.ui.search_prev.png";
    public static final String IMG_LCL_SEARCH_GOTO = "org.eclipse.search.ui.search_goto.png";
    public static final String IMG_LCL_SEARCH_SORT = "org.eclipse.search.ui.search_sortmatch.png";
    public static final String IMG_LCL_SEARCH_HISTORY = "org.eclipse.search.ui.search_history.png";
    public static final String IMG_LCL_SEARCH_FLAT_LAYOUT = "org.eclipse.search.ui.flatLayout.png";
    public static final String IMG_LCL_SEARCH_HIERARCHICAL_LAYOUT = "org.eclipse.search.ui.hierarchicalLayout.png";
    public static final String IMG_LCL_SEARCH_HORIZONTAL_ORIENTATION = "org.eclipse.search.ui.horizontalOrientation.png";
    public static final String IMG_LCL_SEARCH_VERTICAL_ORIENTATION = "org.eclipse.search.ui.verticalOrientation.png";
    public static final String IMG_LCL_SEARCH_AUTOMATIC_ORIENTATION = "org.eclipse.search.ui.automaticOrientation.png";
    public static final String IMG_LCL_SEARCH_SINGLE_ORIENTATION = "org.eclipse.search.ui.singleOrientation.png";
    public static final String IMG_LCL_SEARCH_CANCEL = "org.eclipse.search.ui.stop.png";
    public static final String IMG_LCL_SEARCH_COLLAPSE_ALL = "org.eclipse.search.ui.collapseall.png";
    public static final String IMG_LCL_SEARCH_EXPAND_ALL = "org.eclipse.search.ui.expandall.png";
    public static final String IMG_LCL_SEARCH_FILTER = "org.eclipse.search.ui.filter_ps.png";
    public static final String IMG_VIEW_SEARCHRES = "org.eclipse.search.ui.searchres.png";
    public static final String IMG_OBJ_TSEARCH_DPDN = "org.eclipse.search.ui.tsearch_dpdn_obj.png";
    public static final String IMG_OBJ_SEARCHMARKER = "org.eclipse.search.ui.searchm_obj.png";
    public static final String IMG_OBJ_TEXT_SEARCH_LINE = "org.eclipse.search.ui.line_match.png";
    public static final ImageDescriptor DESC_OBJ_TSEARCH_DPDN = SearchPluginImages.createManaged("obj16/", "org.eclipse.search.ui.tsearch_dpdn_obj.png");
    public static final ImageDescriptor DESC_OBJ_SEARCHMARKER = SearchPluginImages.createManaged("obj16/", "org.eclipse.search.ui.searchm_obj.png");
    public static final ImageDescriptor DESC_OBJ_TEXT_SEARCH_LINE = SearchPluginImages.createManaged("obj16/", "org.eclipse.search.ui.line_match.png");
    public static final ImageDescriptor DESC_VIEW_SEARCHRES = SearchPluginImages.createManaged("eview16/", "org.eclipse.search.ui.searchres.png");

    public static Image get(String key) {
        return PLUGIN_REGISTRY.get(key);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        ImageDescriptor result = SearchPluginImages.create(prefix, name.substring(NAME_PREFIX_LENGTH), true);
        PLUGIN_REGISTRY.put(name, result);
        return result;
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return SearchPluginImages.createImageDescriptor(SearchPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        relPath = relPath.substring(NAME_PREFIX_LENGTH);
        action.setDisabledImageDescriptor(SearchPluginImages.create("d" + type, relPath, false));
        ImageDescriptor desc = SearchPluginImages.create("e" + type, relPath, true);
        action.setHoverImageDescriptor(desc);
        action.setImageDescriptor(desc);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

