"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var path = require("path");
var def = require("./definitionSystem");
function generateJSONDumpOfDefSystem() {
    var universe10 = def.getUniverse("RAML10");
    var universe08 = def.getUniverse("RAML08");
    var Universe10 = {};
    universe10.types().forEach(function (x) {
        var props = {};
        x.allProperties().forEach(function (y) { return props[y.nameId()] = { name: y.nameId() }; });
        x.customProperties().forEach(function (y) { return props[y.nameId()] = { name: y.nameId(), range: y.range().nameId(), domain: y.domain().nameId() }; });
        Universe10[x.nameId()] = {
            name: x.nameId(),
            properties: props
        };
    });
    var Universe08 = {};
    universe08.types().forEach(function (x) {
        var props = {};
        x.allProperties().forEach(function (y) { return props[y.nameId()] = { name: y.nameId(), range: y.range().nameId(), domain: y.domain().nameId() }; });
        x.customProperties().forEach(function (y) { return props[y.nameId()] = { name: y.nameId() }; });
        Universe08[x.nameId()] = {
            name: x.nameId(),
            properties: props
        };
    });
    var Universes = { Universe08: Universe08, Universe10: Universe10 };
    fs.writeFileSync(path.join(__dirname, '../src/universe.ts'), "var Universes=" + JSON.stringify(Universes, null, 2) + ";export=Universes");
}
generateJSONDumpOfDefSystem();
//# sourceMappingURL=enumGen.js.map