/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.trace;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.instrumentation.trace.Status;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EndSpanOptions {
    private final Status status;
    public static final EndSpanOptions DEFAULT = EndSpanOptions.builder().build();

    private EndSpanOptions(Status status) {
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EndSpanOptions)) {
            return false;
        }
        EndSpanOptions that = (EndSpanOptions)obj;
        return Objects.equal((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).toString();
    }

    public static final class Builder {
        private Status status = Status.OK;

        private Builder() {
        }

        public Builder setStatus(Status status) {
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
            return this;
        }

        public EndSpanOptions build() {
            return new EndSpanOptions(this.status);
        }
    }
}

