"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteSelectorView extends _react["default"].Component {
  render() {
    const {
      remotes,
      currentBranch,
      selectRemote
    } = this.props; // todo: ask Ash how to test this before merging.

    return _react["default"].createElement("div", {
      className: "github-RemoteSelector"
    }, _react["default"].createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mirror"
    }), _react["default"].createElement("h1", null, "Select a Remote"), _react["default"].createElement("div", {
      className: "initialize-repo-description"
    }, _react["default"].createElement("span", null, "This repository has multiple remotes hosted at GitHub.com. Select a remote to see pull requests associated with the ", _react["default"].createElement("strong", null, currentBranch.getName()), " branch:")), _react["default"].createElement("ul", null, Array.from(remotes, remote => _react["default"].createElement("li", {
      key: remote.getName()
    }, _react["default"].createElement("button", {
      className: "btn btn-primary",
      onClick: e => selectRemote(e, remote)
    }, remote.getName(), " (", remote.getOwner(), "/", remote.getRepo(), ")")))));
  }

}

exports["default"] = RemoteSelectorView;

_defineProperty(RemoteSelectorView, "propTypes", {
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  selectRemote: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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