Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var BookmarksView = (function () {
  function BookmarksView(editorsBookmarks) {
    var _this = this;

    _classCallCheck(this, BookmarksView);

    this.editorsBookmarks = editorsBookmarks;
    this.selectList = new _atomSelectList2['default']({
      emptyMessage: 'No bookmarks found',
      items: [],
      filterKeyForItem: function filterKeyForItem(bookmark) {
        return bookmark.filterText;
      },
      didConfirmSelection: function didConfirmSelection(_ref) {
        var editor = _ref.editor;
        var marker = _ref.marker;

        _this.hide();
        editor.setSelectedBufferRange(marker.getBufferRange(), { autoscroll: true });
        atom.workspace.paneForItem(editor).activate();
        atom.workspace.paneForItem(editor).activateItem(editor);
      },
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      },
      elementForItem: function elementForItem(_ref2) {
        var marker = _ref2.marker;
        var editor = _ref2.editor;

        var bookmarkStartRow = marker.getStartBufferPosition().row;
        var bookmarkEndRow = marker.getEndBufferPosition().row;
        var bookmarkPath = editor.getPath() ? _path2['default'].basename(editor.getPath()) : 'untitled';
        var bookmarkLocation = bookmarkPath + ':' + (bookmarkStartRow + 1);
        if (bookmarkStartRow !== bookmarkEndRow) {
          bookmarkLocation += '-' + (bookmarkEndRow + 1);
        }

        var lineText = editor.lineTextForBufferRow(bookmarkStartRow);
        var li = document.createElement('li');
        li.classList.add('bookmark');
        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = bookmarkLocation;
        li.appendChild(primaryLine);
        if (lineText) {
          var secondaryLine = document.createElement('div');
          secondaryLine.classList.add('secondary-line', 'line-text');
          secondaryLine.textContent = lineText.trim();
          li.appendChild(secondaryLine);
          li.classList.add('two-lines');
        }
        return li;
      }
    });
    this.selectList.element.classList.add('bookmarks-view');
  }

  _createClass(BookmarksView, [{
    key: 'destroy',
    value: function destroy() {
      this.selectList.destroy();
      this.getModalPanel().destroy();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'show',
    value: _asyncToGenerator(function* () {
      var bookmarks = [];
      for (var _ref32 of this.editorsBookmarks) {
        var editor = _ref32.editor;
        var markerLayer = _ref32.markerLayer;

        for (var marker of markerLayer.getMarkers()) {
          var filterText = '' + marker.getStartBufferPosition().row;

          if (editor.getPath()) {
            filterText += ' ' + editor.getPath();
          }

          var bookmarkedLineText = editor.lineTextForBufferRow(marker.getStartBufferPosition().row);
          if (bookmarkedLineText) {
            filterText += ' ' + bookmarkedLineText.trim();
          }

          bookmarks.push({ marker: marker, editor: editor, filterText: filterText });
        }
      }

      this.previouslyFocusedElement = document.activeElement;
      this.selectList.reset();
      yield this.selectList.update({ items: bookmarks });
      this.getModalPanel().show();
      this.selectList.focus();
    })
  }, {
    key: 'hide',
    value: function hide() {
      this.getModalPanel().hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'getModalPanel',
    value: function getModalPanel() {
      if (!this.modalPanel) {
        this.modalPanel = atom.workspace.addModalPanel({ item: this.selectList });
      }
      return this.modalPanel;
    }
  }]);

  return BookmarksView;
})();

exports['default'] = BookmarksView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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