/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json.impl;

import com.oracle.javafx.jmx.json.JSONDocument;
import com.oracle.javafx.jmx.json.JSONException;
import com.oracle.javafx.jmx.json.JSONReader;
import com.oracle.javafx.jmx.json.impl.JSONMessages;
import com.oracle.javafx.jmx.json.impl.JSONScanner;
import com.oracle.javafx.jmx.json.impl.JSONSymbol;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Stack;

public class JSONStreamReaderImpl
implements JSONReader {
    private JSONScanner scanner;
    private JSONSymbol currentSymbol;
    private JSONReader.EventType currentEvent;
    private volatile boolean nullValue;
    private String key;
    private Stack<String> stack = new Stack();
    private boolean eod = false;
    private JSONDocument collection = null;
    private String collectionKey = null;
    private int depth = 0;

    public JSONStreamReaderImpl(Reader reader) throws JSONException {
        this.currentSymbol = JSONSymbol.EOS;
        try {
            this.scanner = new JSONScanner(reader);
            JSONSymbol.init(this.scanner);
        }
        catch (IOException e) {
            throw new JSONException(e, this.scanner.line(), this.scanner.column());
        }
    }

    @Override
    public Iterator<JSONReader.EventType> iterator() {
        return this;
    }

    @Override
    public JSONReader.EventType next(String objectName, int depth) throws JSONException {
        if (objectName == null && depth < 0) {
            throw new IllegalArgumentException(JSONMessages.localize(null, "either_objectName_or_level_must_be_specified"));
        }
        JSONReader.EventType type = JSONReader.EventType.END_DOCUMENT;
        type = this.next();
        while (!(type == JSONReader.EventType.END_DOCUMENT || type == JSONReader.EventType.ERROR || type == JSONReader.EventType.START_VALUE && (objectName != null && depth >= 0 ? this.checkName(objectName) && this.checkLevel(depth) : objectName != null && this.checkName(objectName) || depth >= 0 && this.checkLevel(depth)))) {
            type = this.next();
        }
        return type;
    }

    private boolean checkName(String objectName) {
        return objectName.equals(this.key());
    }

    private boolean checkLevel(int level) {
        return level == this.depth;
    }

    @Override
    public JSONReader.EventType next() throws JSONException {
        boolean found = false;
        if (this.eod) {
            this.currentEvent = JSONReader.EventType.END_DOCUMENT;
            return this.currentEvent;
        }
        this.nullValue = false;
        while (!found) {
            try {
                this.currentSymbol = JSONSymbol.next();
            }
            catch (IOException e) {
                throw new JSONException(e, this.scanner.line(), this.scanner.column());
            }
            switch (this.currentSymbol) {
                case O: {
                    this.key = null;
                    ++this.depth;
                    this.currentEvent = JSONReader.EventType.START_OBJECT;
                    return this.currentEvent;
                }
                case O_: {
                    this.key = null;
                    --this.depth;
                    this.currentEvent = JSONReader.EventType.END_OBJECT;
                    return this.currentEvent;
                }
                case OV: {
                    if (this.next() == JSONReader.EventType.STRING) {
                        this.key = JSONSymbol.getValue();
                    }
                    this.stack.push(this.key);
                    this.nullValue = true;
                    this.currentEvent = JSONReader.EventType.START_VALUE;
                    return this.currentEvent;
                }
                case OV_: {
                    this.key = this.stack.pop();
                    this.nullValue = true;
                    this.currentEvent = JSONReader.EventType.END_VALUE;
                    return this.currentEvent;
                }
                case X: {
                    this.depth = -1;
                    this.stack.removeAllElements();
                    this.currentEvent = JSONReader.EventType.START_DOCUMENT;
                    return this.currentEvent;
                }
                case X_: {
                    this.eod = true;
                    this.stack.removeAllElements();
                }
                case EOS: {
                    if (!this.eod) {
                        throw new JSONException(JSONMessages.localize(null, "unexpected_end_of_stream"), this.scanner.line(), this.scanner.column());
                    }
                    this.depth = -1;
                    this.currentEvent = JSONReader.EventType.END_DOCUMENT;
                    return this.currentEvent;
                }
                case KEYWORD: {
                    String s = JSONSymbol.getValue();
                    if (s.equals("true")) {
                        this.nullValue = true;
                        this.currentEvent = JSONReader.EventType.TRUE;
                        return this.currentEvent;
                    }
                    if (s.equals("false")) {
                        this.nullValue = true;
                        this.currentEvent = JSONReader.EventType.FALSE;
                        return this.currentEvent;
                    }
                    if (s.equals("null")) {
                        this.nullValue = true;
                        this.currentEvent = JSONReader.EventType.NULL;
                        return this.currentEvent;
                    }
                    this.currentEvent = JSONReader.EventType.ERROR;
                    return this.currentEvent;
                }
                case STRING: {
                    this.currentEvent = JSONReader.EventType.STRING;
                    return this.currentEvent;
                }
                case NUMBER: {
                    if (this.scanner.isInteger()) {
                        this.currentEvent = JSONReader.EventType.INTEGER;
                        return this.currentEvent;
                    }
                    this.currentEvent = JSONReader.EventType.NUMBER;
                    return this.currentEvent;
                }
                case A: {
                    this.currentEvent = JSONReader.EventType.START_ARRAY;
                    return this.currentEvent;
                }
                case A_: {
                    this.currentEvent = JSONReader.EventType.END_ARRAY;
                    return this.currentEvent;
                }
                case VA: {
                    this.currentEvent = JSONReader.EventType.START_ARRAY_ELEMENT;
                    return this.currentEvent;
                }
                case VA_: {
                    this.nullValue = true;
                    this.currentEvent = JSONReader.EventType.END_ARRAY_ELEMENT;
                    return this.currentEvent;
                }
            }
            found = false;
        }
        this.currentEvent = JSONReader.EventType.ERROR;
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() {
        return this.currentSymbol != JSONSymbol.X_;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String value() {
        return this.nullValue ? null : JSONSymbol.getValue();
    }

    @Override
    public int line() {
        return this.scanner.line();
    }

    @Override
    public int column() {
        return this.scanner.column();
    }

    @Override
    public long offset() {
        return this.scanner.getCharacterOffset();
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public String[] path() {
        String[] path = new String[this.stack.size()];
        Iterator si = this.stack.iterator();
        int i = 0;
        while (si.hasNext()) {
            path[i++] = (String)si.next();
        }
        return path;
    }

    @Override
    public String key() {
        return this.key;
    }

    public String toString() {
        String keyString = this.key() == null ? "" : this.key();
        String valueString = this.value() == null ? "" : this.value();
        return "(" + this.scanner.line() + ":" + this.scanner.column() + ") " + (Object)((Object)this.currentEvent) + " " + ("".equals(keyString) && "".equals(valueString) ? "" : "(" + keyString + ", " + valueString + ")");
    }

    @Override
    public JSONDocument build() {
        if (this.currentEvent != JSONReader.EventType.START_ARRAY && this.currentEvent != JSONReader.EventType.START_OBJECT) {
            JSONReader.EventType type = this.next();
            while (type != JSONReader.EventType.END_DOCUMENT && type != JSONReader.EventType.ERROR && type != JSONReader.EventType.START_ARRAY && type != JSONReader.EventType.START_OBJECT) {
                type = this.next();
            }
        }
        Stack<JSONDocument> collectionStack = new Stack<JSONDocument>();
        switch (this.currentEvent) {
            case END_DOCUMENT: {
                return null;
            }
            case START_ARRAY: {
                this.collection = new JSONDocument(JSONDocument.Type.ARRAY);
                break;
            }
            case START_OBJECT: {
                this.collection = new JSONDocument(JSONDocument.Type.OBJECT);
            }
        }
        JSONDocument root = collectionStack.push(this.collection);
        JSONReader.EventType type = this.next();
        while (type != JSONReader.EventType.END_DOCUMENT && type != JSONReader.EventType.ERROR && !collectionStack.empty()) {
            this.insert(type, collectionStack);
            type = this.next();
        }
        return root;
    }

    private void insert(JSONReader.EventType type, Stack<JSONDocument> collectionStack) throws NumberFormatException {
        switch (type) {
            case TRUE: {
                this.insert(Boolean.TRUE);
                break;
            }
            case FALSE: {
                this.insert(Boolean.FALSE);
                break;
            }
            case NULL: {
                this.insert(null);
                break;
            }
            case STRING: {
                this.insert(this.value());
                break;
            }
            case INTEGER: {
                this.insert(Long.parseLong(this.value()));
                break;
            }
            case NUMBER: {
                this.insert(Double.parseDouble(this.value()));
                break;
            }
            case START_ARRAY: {
                collectionStack.push(this.collection);
                JSONDocument array = new JSONDocument(JSONDocument.Type.ARRAY);
                this.insert(array);
                this.collection = array;
                break;
            }
            case END_ARRAY: {
                this.collection = collectionStack.pop();
                break;
            }
            case START_VALUE: {
                this.collectionKey = this.key();
                break;
            }
            case END_VALUE: {
                this.collectionKey = null;
                break;
            }
            case START_OBJECT: {
                collectionStack.push(this.collection);
                JSONDocument map = new JSONDocument(JSONDocument.Type.OBJECT);
                this.insert(map);
                this.collection = map;
                break;
            }
            case END_OBJECT: {
                this.collection = collectionStack.pop();
            }
        }
    }

    private void insert(Object value) {
        if (this.collection.isArray()) {
            this.collection.array().add(value);
        } else if (this.collection.isObject()) {
            this.collection.object().put(this.collectionKey, value);
        } else assert (false);
    }

    @Override
    public void close() {
        try {
            this.scanner.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

