/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.UnmodifiableArrayList;
import com.sun.javafx.css.SubCssMetaData;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.scene.layout.region.CornerRadiiConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundPositionConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundSizeConverter;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import com.sun.javafx.scene.layout.region.RepeatStructConverter;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public final class Background {
    static final CssMetaData<Node, Paint[]> BACKGROUND_COLOR = new SubCssMetaData<Paint[]>("-fx-background-color", (StyleConverter)PaintConverter.SequenceConverter.getInstance(), new Paint[]{Color.TRANSPARENT});
    static final CssMetaData<Node, CornerRadii[]> BACKGROUND_RADIUS = new SubCssMetaData<CornerRadii[]>("-fx-background-radius", (StyleConverter)CornerRadiiConverter.getInstance(), new CornerRadii[]{CornerRadii.EMPTY});
    static final CssMetaData<Node, Insets[]> BACKGROUND_INSETS = new SubCssMetaData<Insets[]>("-fx-background-insets", (StyleConverter)InsetsConverter.SequenceConverter.getInstance(), new Insets[]{Insets.EMPTY});
    static final CssMetaData<Node, javafx.scene.image.Image[]> BACKGROUND_IMAGE = new SubCssMetaData<javafx.scene.image.Image[]>("-fx-background-image", (StyleConverter)URLConverter.SequenceConverter.getInstance());
    static final CssMetaData<Node, RepeatStruct[]> BACKGROUND_REPEAT = new SubCssMetaData<RepeatStruct[]>("-fx-background-repeat", (StyleConverter)RepeatStructConverter.getInstance(), new RepeatStruct[]{new RepeatStruct(BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT)});
    static final CssMetaData<Node, BackgroundPosition[]> BACKGROUND_POSITION = new SubCssMetaData<BackgroundPosition[]>("-fx-background-position", (StyleConverter)LayeredBackgroundPositionConverter.getInstance(), new BackgroundPosition[]{BackgroundPosition.DEFAULT});
    static final CssMetaData<Node, BackgroundSize[]> BACKGROUND_SIZE = new SubCssMetaData<BackgroundSize[]>("-fx-background-size", (StyleConverter)LayeredBackgroundSizeConverter.getInstance(), new BackgroundSize[]{BackgroundSize.DEFAULT});
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = Collections.unmodifiableList(Arrays.asList(BACKGROUND_COLOR, BACKGROUND_INSETS, BACKGROUND_RADIUS, BACKGROUND_IMAGE, BACKGROUND_REPEAT, BACKGROUND_POSITION, BACKGROUND_SIZE));
    public static final Background EMPTY = new Background((BackgroundFill[])null, null);
    final List<BackgroundFill> fills;
    final List<BackgroundImage> images;
    final Insets outsets;
    private final boolean hasOpaqueFill;
    private final double opaqueFillTop;
    private final double opaqueFillRight;
    private final double opaqueFillBottom;
    private final double opaqueFillLeft;
    final boolean hasPercentageBasedOpaqueFills;
    final boolean hasPercentageBasedFills;
    private final int hash;

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public final List<BackgroundFill> getFills() {
        return this.fills;
    }

    public final List<BackgroundImage> getImages() {
        return this.images;
    }

    public final Insets getOutsets() {
        return this.outsets;
    }

    public final boolean isEmpty() {
        return this.fills.isEmpty() && this.images.isEmpty();
    }

    public Background(BackgroundFill ... fills) {
        this(fills, (BackgroundImage[])null);
    }

    public Background(BackgroundImage ... images) {
        this((BackgroundFill[])null, images);
    }

    public Background(@NamedArg(value="fills") List<BackgroundFill> fills, @NamedArg(value="images") List<BackgroundImage> images) {
        this(fills == null ? null : fills.toArray(new BackgroundFill[fills.size()]), images == null ? null : images.toArray(new BackgroundImage[images.size()]));
    }

    public Background(@NamedArg(value="fills") BackgroundFill[] fills, @NamedArg(value="images") BackgroundImage[] images) {
        int i;
        int size;
        Object[] noNulls;
        double outerTop = 0.0;
        double outerRight = 0.0;
        double outerBottom = 0.0;
        double outerLeft = 0.0;
        boolean hasPercentOpaqueInsets = false;
        boolean hasPercentFillRadii = false;
        boolean opaqueFill = false;
        if (fills == null || fills.length == 0) {
            this.fills = Collections.emptyList();
        } else {
            noNulls = new BackgroundFill[fills.length];
            size = 0;
            for (i = 0; i < fills.length; ++i) {
                BackgroundFill fill = fills[i];
                if (fill == null) continue;
                noNulls[size++] = fill;
                Insets fillInsets = fill.getInsets();
                double fillTop = fillInsets.getTop();
                double fillRight = fillInsets.getRight();
                double fillBottom = fillInsets.getBottom();
                double fillLeft = fillInsets.getLeft();
                outerTop = outerTop <= fillTop ? outerTop : fillTop;
                outerRight = outerRight <= fillRight ? outerRight : fillRight;
                outerBottom = outerBottom <= fillBottom ? outerBottom : fillBottom;
                outerLeft = outerLeft <= fillLeft ? outerLeft : fillLeft;
                boolean b = fill.getRadii().hasPercentBasedRadii;
                hasPercentFillRadii |= b;
                if (!fill.fill.isOpaque()) continue;
                opaqueFill = true;
                if (!b) continue;
                hasPercentOpaqueInsets = true;
            }
            this.fills = new UnmodifiableArrayList<BackgroundFill>(noNulls, size);
        }
        this.hasPercentageBasedFills = hasPercentFillRadii;
        this.outsets = new Insets(Math.max(0.0, -outerTop), Math.max(0.0, -outerRight), Math.max(0.0, -outerBottom), Math.max(0.0, -outerLeft));
        if (images == null || images.length == 0) {
            this.images = Collections.emptyList();
        } else {
            noNulls = new BackgroundImage[images.length];
            size = 0;
            for (i = 0; i < images.length; ++i) {
                BackgroundImage image = images[i];
                if (image == null) continue;
                noNulls[size++] = image;
            }
            this.images = new UnmodifiableArrayList<Object>(noNulls, size);
        }
        this.hasOpaqueFill = opaqueFill;
        if (hasPercentOpaqueInsets) {
            this.opaqueFillTop = Double.NaN;
            this.opaqueFillRight = Double.NaN;
            this.opaqueFillBottom = Double.NaN;
            this.opaqueFillLeft = Double.NaN;
        } else {
            double[] trbl = new double[4];
            this.computeOpaqueInsets(1.0, 1.0, true, trbl);
            this.opaqueFillTop = trbl[0];
            this.opaqueFillRight = trbl[1];
            this.opaqueFillBottom = trbl[2];
            this.opaqueFillLeft = trbl[3];
        }
        this.hasPercentageBasedOpaqueFills = hasPercentOpaqueInsets;
        int result = this.fills.hashCode();
        this.hash = result = 31 * result + this.images.hashCode();
    }

    public boolean isFillPercentageBased() {
        return this.hasPercentageBasedFills;
    }

    void computeOpaqueInsets(double width, double height, double[] trbl) {
        this.computeOpaqueInsets(width, height, false, trbl);
    }

    private void computeOpaqueInsets(double width, double height, boolean firstTime, double[] trbl) {
        double opaqueRegionTop = Double.NaN;
        double opaqueRegionRight = Double.NaN;
        double opaqueRegionBottom = Double.NaN;
        double opaqueRegionLeft = Double.NaN;
        if (this.hasOpaqueFill) {
            if (!firstTime && !this.hasPercentageBasedOpaqueFills) {
                opaqueRegionTop = this.opaqueFillTop;
                opaqueRegionRight = this.opaqueFillRight;
                opaqueRegionBottom = this.opaqueFillBottom;
                opaqueRegionLeft = this.opaqueFillLeft;
            } else {
                int max = this.fills.size();
                for (int i = 0; i < max; ++i) {
                    boolean largerLeft;
                    BackgroundFill fill = this.fills.get(i);
                    Insets fillInsets = fill.getInsets();
                    double fillTop = fillInsets.getTop();
                    double fillRight = fillInsets.getRight();
                    double fillBottom = fillInsets.getBottom();
                    double fillLeft = fillInsets.getLeft();
                    if (!fill.fill.isOpaque()) continue;
                    CornerRadii radii = fill.getRadii();
                    double topLeftHorizontalRadius = radii.isTopLeftHorizontalRadiusAsPercentage() ? width * radii.getTopLeftHorizontalRadius() : radii.getTopLeftHorizontalRadius();
                    double topLeftVerticalRadius = radii.isTopLeftVerticalRadiusAsPercentage() ? height * radii.getTopLeftVerticalRadius() : radii.getTopLeftVerticalRadius();
                    double topRightVerticalRadius = radii.isTopRightVerticalRadiusAsPercentage() ? height * radii.getTopRightVerticalRadius() : radii.getTopRightVerticalRadius();
                    double topRightHorizontalRadius = radii.isTopRightHorizontalRadiusAsPercentage() ? width * radii.getTopRightHorizontalRadius() : radii.getTopRightHorizontalRadius();
                    double bottomRightHorizontalRadius = radii.isBottomRightHorizontalRadiusAsPercentage() ? width * radii.getBottomRightHorizontalRadius() : radii.getBottomRightHorizontalRadius();
                    double bottomRightVerticalRadius = radii.isBottomRightVerticalRadiusAsPercentage() ? height * radii.getBottomRightVerticalRadius() : radii.getBottomRightVerticalRadius();
                    double bottomLeftVerticalRadius = radii.isBottomLeftVerticalRadiusAsPercentage() ? height * radii.getBottomLeftVerticalRadius() : radii.getBottomLeftVerticalRadius();
                    double bottomLeftHorizontalRadius = radii.isBottomLeftHorizontalRadiusAsPercentage() ? width * radii.getBottomLeftHorizontalRadius() : radii.getBottomLeftHorizontalRadius();
                    double t = fillTop + Math.max(topLeftVerticalRadius, topRightVerticalRadius) / 2.0;
                    double r = fillRight + Math.max(topRightHorizontalRadius, bottomRightHorizontalRadius) / 2.0;
                    double b = fillBottom + Math.max(bottomLeftVerticalRadius, bottomRightVerticalRadius) / 2.0;
                    double l = fillLeft + Math.max(topLeftHorizontalRadius, bottomLeftHorizontalRadius) / 2.0;
                    if (Double.isNaN(opaqueRegionTop)) {
                        opaqueRegionTop = t;
                        opaqueRegionRight = r;
                        opaqueRegionBottom = b;
                        opaqueRegionLeft = l;
                        continue;
                    }
                    boolean largerTop = t >= opaqueRegionTop;
                    boolean largerRight = r >= opaqueRegionRight;
                    boolean largerBottom = b >= opaqueRegionBottom;
                    boolean bl = largerLeft = l >= opaqueRegionLeft;
                    if (largerTop && largerRight && largerBottom && largerLeft) continue;
                    if (!(largerTop || largerRight || largerBottom || largerLeft)) {
                        opaqueRegionTop = fillTop;
                        opaqueRegionRight = fillRight;
                        opaqueRegionBottom = fillBottom;
                        opaqueRegionLeft = fillLeft;
                        continue;
                    }
                    if (l == opaqueRegionLeft && r == opaqueRegionRight) {
                        opaqueRegionTop = Math.min(t, opaqueRegionTop);
                        opaqueRegionBottom = Math.min(b, opaqueRegionBottom);
                        continue;
                    }
                    if (t != opaqueRegionTop || b != opaqueRegionBottom) continue;
                    opaqueRegionLeft = Math.min(l, opaqueRegionLeft);
                    opaqueRegionRight = Math.min(r, opaqueRegionRight);
                }
            }
        }
        Toolkit.ImageAccessor acc = Toolkit.getImageAccessor();
        for (BackgroundImage bi : this.images) {
            double scale;
            double tileHeight;
            double tileWidth;
            boolean filledY;
            if (bi.opaque == null) {
                PlatformImage platformImage = (PlatformImage)acc.getImageProperty(bi.image).get();
                if (platformImage == null || !(platformImage instanceof Image)) continue;
                bi.opaque = ((Image)platformImage).isOpaque();
            }
            if (!bi.opaque.booleanValue()) continue;
            if (bi.size.cover || bi.size.height == -1.0 && bi.size.width == -1.0 && bi.size.widthAsPercentage && bi.size.heightAsPercentage) {
                opaqueRegionTop = Double.isNaN(opaqueRegionTop) ? 0.0 : Math.min(0.0, opaqueRegionTop);
                opaqueRegionRight = Double.isNaN(opaqueRegionRight) ? 0.0 : Math.min(0.0, opaqueRegionRight);
                opaqueRegionBottom = Double.isNaN(opaqueRegionBottom) ? 0.0 : Math.min(0.0, opaqueRegionBottom);
                opaqueRegionLeft = Double.isNaN(opaqueRegionLeft) ? 0.0 : Math.min(0.0, opaqueRegionLeft);
                break;
            }
            if (bi.repeatX == BackgroundRepeat.SPACE || bi.repeatY == BackgroundRepeat.SPACE) {
                bi.opaque = false;
                continue;
            }
            boolean filledX = bi.repeatX == BackgroundRepeat.REPEAT || bi.repeatX == BackgroundRepeat.ROUND;
            boolean bl = filledY = bi.repeatY == BackgroundRepeat.REPEAT || bi.repeatY == BackgroundRepeat.ROUND;
            if (filledX && filledY) {
                opaqueRegionTop = Double.isNaN(opaqueRegionTop) ? 0.0 : Math.min(0.0, opaqueRegionTop);
                opaqueRegionRight = Double.isNaN(opaqueRegionRight) ? 0.0 : Math.min(0.0, opaqueRegionRight);
                opaqueRegionBottom = Double.isNaN(opaqueRegionBottom) ? 0.0 : Math.min(0.0, opaqueRegionBottom);
                opaqueRegionLeft = Double.isNaN(opaqueRegionLeft) ? 0.0 : Math.min(0.0, opaqueRegionLeft);
                break;
            }
            double w = bi.size.widthAsPercentage ? bi.size.width * width : bi.size.width;
            double h = bi.size.heightAsPercentage ? bi.size.height * height : bi.size.height;
            double imgUnscaledWidth = bi.image.getWidth();
            double imgUnscaledHeight = bi.image.getHeight();
            if (bi.size.contain) {
                double scaleX = width / imgUnscaledWidth;
                double scaleY = height / imgUnscaledHeight;
                double scale2 = Math.min(scaleX, scaleY);
                tileWidth = Math.ceil(scale2 * imgUnscaledWidth);
                tileHeight = Math.ceil(scale2 * imgUnscaledHeight);
            } else if (bi.size.width >= 0.0 && bi.size.height >= 0.0) {
                tileWidth = w;
                tileHeight = h;
            } else if (w >= 0.0) {
                tileWidth = w;
                scale = tileWidth / imgUnscaledWidth;
                tileHeight = imgUnscaledHeight * scale;
            } else if (h >= 0.0) {
                tileHeight = h;
                scale = tileHeight / imgUnscaledHeight;
                tileWidth = imgUnscaledWidth * scale;
            } else {
                tileWidth = imgUnscaledWidth;
                tileHeight = imgUnscaledHeight;
            }
            opaqueRegionTop = Double.isNaN(opaqueRegionTop) ? 0.0 : Math.min(0.0, opaqueRegionTop);
            opaqueRegionRight = Double.isNaN(opaqueRegionRight) ? width - tileWidth : Math.min(width - tileWidth, opaqueRegionRight);
            opaqueRegionBottom = Double.isNaN(opaqueRegionBottom) ? height - tileHeight : Math.min(height - tileHeight, opaqueRegionBottom);
            opaqueRegionLeft = Double.isNaN(opaqueRegionLeft) ? 0.0 : Math.min(0.0, opaqueRegionLeft);
        }
        trbl[0] = opaqueRegionTop;
        trbl[1] = opaqueRegionRight;
        trbl[2] = opaqueRegionBottom;
        trbl[3] = opaqueRegionLeft;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Background that = (Background)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (!this.fills.equals(that.fills)) {
            return false;
        }
        return this.images.equals(that.images);
    }

    public int hashCode() {
        return this.hash;
    }
}

