/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.light.Light;
import com.sun.scenario.effect.light.PointLight;

public class SpotLight
extends PointLight {
    private float pointsAtX = 0.0f;
    private float pointsAtY = 0.0f;
    private float pointsAtZ = 0.0f;
    private float specularExponent = 1.0f;

    public SpotLight() {
        this(0.0f, 0.0f, 0.0f, Color4f.WHITE);
    }

    public SpotLight(float x, float y, float z, Color4f color) {
        super(Light.Type.SPOT, x, y, z, color);
    }

    public float getPointsAtX() {
        return this.pointsAtX;
    }

    public void setPointsAtX(float pointsAtX) {
        this.pointsAtX = pointsAtX;
    }

    public float getPointsAtY() {
        return this.pointsAtY;
    }

    public void setPointsAtY(float pointsAtY) {
        float old = this.pointsAtY;
        this.pointsAtY = pointsAtY;
    }

    public float getPointsAtZ() {
        return this.pointsAtZ;
    }

    public void setPointsAtZ(float pointsAtZ) {
        this.pointsAtZ = pointsAtZ;
    }

    public float getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(float specularExponent) {
        if (specularExponent < 0.0f || specularExponent > 4.0f) {
            throw new IllegalArgumentException("Specular exponent must be in the range [0,4]");
        }
        this.specularExponent = specularExponent;
    }

    @Override
    public float[] getNormalizedLightPosition() {
        float z;
        float y;
        float x = this.getX();
        float len = (float)Math.sqrt(x * x + (y = this.getY()) * y + (z = this.getZ()) * z);
        if (len == 0.0f) {
            len = 1.0f;
        }
        float[] pos = new float[]{x / len, y / len, z / len};
        return pos;
    }

    public float[] getNormalizedLightDirection() {
        float sz;
        float sy;
        float sx = this.pointsAtX - this.getX();
        float len = (float)Math.sqrt(sx * sx + (sy = this.pointsAtY - this.getY()) * sy + (sz = this.pointsAtZ - this.getZ()) * sz);
        if (len == 0.0f) {
            len = 1.0f;
        }
        float[] vec = new float[]{sx / len, sy / len, sz / len};
        return vec;
    }
}

