/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.Texture;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderGraphics;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrTexture;
import com.sun.scenario.effect.impl.prism.ps.PPSDrawable;
import com.sun.scenario.effect.impl.prism.ps.PPSEffectPeer;
import com.sun.scenario.effect.impl.prism.ps.PPSRenderer;

public abstract class PPSTwoSamplerPeer
extends PPSEffectPeer {
    private Shader shader;

    protected PPSTwoSamplerPeer(FilterContext fctx, Renderer r, String shaderName) {
        super(fctx, r, shaderName);
    }

    @Override
    public void dispose() {
        if (this.shader != null) {
            this.shader.dispose();
        }
    }

    @Override
    ImageData filterImpl(ImageData ... inputs) {
        int src1Coords;
        PrTexture src1Tex;
        Rectangle dstBounds = this.getDestBounds();
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        PPSRenderer renderer = this.getRenderer();
        PPSDrawable dst = renderer.getCompatibleImage(dstw, dsth);
        if (dst == null) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        this.setDestNativeBounds(dst.getPhysicalWidth(), dst.getPhysicalHeight());
        Filterable src0F = inputs[0].getUntransformedImage();
        PrTexture src0Tex = (PrTexture)((Object)src0F);
        Rectangle src0Bounds = inputs[0].getUntransformedBounds();
        BaseTransform src0Transform = inputs[0].getTransform();
        this.setInputBounds(0, src0Bounds);
        this.setInputTransform(0, src0Transform);
        this.setInputNativeBounds(0, src0Tex.getNativeBounds());
        float[] src1Rect = new float[8];
        if (inputs.length > 1) {
            Filterable src1F = inputs[1].getUntransformedImage();
            src1Tex = (PrTexture)((Object)src1F);
            if (src1Tex == null) {
                renderer.markLost();
                return new ImageData(this.getFilterContext(), dst, dstBounds);
            }
            Rectangle src1Bounds = inputs[1].getUntransformedBounds();
            BaseTransform src1Transform = inputs[1].getTransform();
            this.setInputBounds(1, src1Bounds);
            this.setInputTransform(1, src1Transform);
            this.setInputNativeBounds(1, src1Tex.getNativeBounds());
            src1Coords = this.getTextureCoordinates(1, src1Rect, src1Bounds.x, src1Bounds.y, src1F.getPhysicalWidth(), src1F.getPhysicalHeight(), dstBounds, src1Transform);
        } else {
            FloatMap map = (FloatMap)this.getSamplerData(1);
            src1Tex = (PrTexture)map.getAccelData(this.getFilterContext());
            if (src1Tex == null) {
                renderer.markLost();
                return new ImageData(this.getFilterContext(), dst, dstBounds);
            }
            Rectangle b = new Rectangle(map.getWidth(), map.getHeight());
            Rectangle nb = src1Tex.getNativeBounds();
            this.setInputBounds(1, b);
            this.setInputNativeBounds(1, nb);
            src1Rect[1] = 0.0f;
            src1Rect[0] = 0.0f;
            src1Rect[2] = (float)b.width / (float)nb.width;
            src1Rect[3] = (float)b.height / (float)nb.height;
            src1Coords = 4;
        }
        float[] src0Rect = new float[8];
        int src0Coords = this.getTextureCoordinates(0, src0Rect, src0Bounds.x, src0Bounds.y, src0F.getPhysicalWidth(), src0F.getPhysicalHeight(), dstBounds, src0Transform);
        ShaderGraphics g = dst.createGraphics();
        if (g == null) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        if (this.shader == null) {
            this.shader = this.createShader();
        }
        if (this.shader == null || !this.shader.isValid()) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        g.setExternalShader(this.shader);
        this.updateShader(this.shader);
        float dx1 = 0.0f;
        float dy1 = 0.0f;
        float dx2 = dstw;
        float dy2 = dsth;
        Object ptex0 = src0Tex.getTextureObject();
        if (ptex0 == null) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        Object ptex1 = src1Tex.getTextureObject();
        if (ptex1 == null) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        float t0xoff = (float)ptex0.getContentX() / (float)ptex0.getPhysicalWidth();
        float t0yoff = (float)ptex0.getContentY() / (float)ptex0.getPhysicalHeight();
        float t0x11 = t0xoff + src0Rect[0];
        float t0y11 = t0yoff + src0Rect[1];
        float t0x22 = t0xoff + src0Rect[2];
        float t0y22 = t0yoff + src0Rect[3];
        float t1xoff = (float)ptex1.getContentX() / (float)ptex1.getPhysicalWidth();
        float t1yoff = (float)ptex1.getContentY() / (float)ptex1.getPhysicalHeight();
        float t1x11 = t1xoff + src1Rect[0];
        float t1y11 = t1yoff + src1Rect[1];
        float t1x22 = t1xoff + src1Rect[2];
        float t1y22 = t1yoff + src1Rect[3];
        if (src0Coords < 8 && src1Coords < 8) {
            g.drawTextureRaw2((Texture)ptex0, (Texture)ptex1, dx1, dy1, dx2, dy2, t0x11, t0y11, t0x22, t0y22, t1x11, t1y11, t1x22, t1y22);
        } else {
            float t1y12;
            float t1x12;
            float t1y21;
            float t1x21;
            float t0y12;
            float t0x12;
            float t0y21;
            float t0x21;
            if (src0Coords < 8) {
                t0x21 = t0x22;
                t0y21 = t0y11;
                t0x12 = t0x11;
                t0y12 = t0y22;
            } else {
                t0x21 = t0xoff + src0Rect[4];
                t0y21 = t0yoff + src0Rect[5];
                t0x12 = t0xoff + src0Rect[6];
                t0y12 = t0yoff + src0Rect[7];
            }
            if (src1Coords < 8) {
                t1x21 = t1x22;
                t1y21 = t1y11;
                t1x12 = t1x11;
                t1y12 = t1y22;
            } else {
                t1x21 = t1xoff + src1Rect[4];
                t1y21 = t1yoff + src1Rect[5];
                t1x12 = t1xoff + src1Rect[6];
                t1y12 = t1yoff + src1Rect[7];
            }
            g.drawMappedTextureRaw2((Texture)ptex0, (Texture)ptex1, dx1, dy1, dx2, dy2, t0x11, t0y11, t0x21, t0y21, t0x12, t0y12, t0x22, t0y22, t1x11, t1y11, t1x21, t1y21, t1x12, t1y12, t1x22, t1y22);
        }
        g.setExternalShader(null);
        if (inputs.length <= 1) {
            src1Tex.unlock();
        }
        return new ImageData(this.getFilterContext(), dst, dstBounds);
    }
}

