#ifndef _EFL_THREADIO_EO_H_
#define _EFL_THREADIO_EO_H_

#ifndef _EFL_THREADIO_EO_CLASS_TYPE
#define _EFL_THREADIO_EO_CLASS_TYPE

typedef Eo Efl_ThreadIO;

#endif

#ifndef _EFL_THREADIO_EO_TYPES
#define _EFL_THREADIO_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** A Function to call on the "other end" of a thread obvject
 *
 * @ingroup EFlThreadIOCall
 */
typedef void (*EFlThreadIOCall)(void *data, const Efl_Event *event);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** A Function to call on the "other end" of a thread obvject
 *
 * @ingroup EFlThreadIOCallSync
 */
typedef void * (*EFlThreadIOCallSync)(void *data, const Efl_Event *event);
#endif /* EFL_BETA_API_SUPPORT */


#endif
#ifdef EFL_BETA_API_SUPPORT
/** No description supplied.
 *
 * @ingroup Efl_ThreadIO
 */
#define EFL_THREADIO_MIXIN efl_threadio_mixin_get()

EWAPI const Efl_Class *efl_threadio_mixin_get(void);

EOAPI void efl_threadio_indata_set(Eo *obj, void *data);

EOAPI void *efl_threadio_indata_get(const Eo *obj);

EOAPI void efl_threadio_outdata_set(Eo *obj, void *data);

EOAPI void *efl_threadio_outdata_get(const Eo *obj);

EOAPI void efl_threadio_call(Eo *obj, void *func_data, EFlThreadIOCall func, Eina_Free_Cb func_free_cb);

EOAPI void *efl_threadio_call_sync(Eo *obj, void *func_data, EFlThreadIOCallSync func, Eina_Free_Cb func_free_cb);
#endif /* EFL_BETA_API_SUPPORT */

#endif
