"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Electron = require("electron");
var pointInRectangle = function (point, rectangle) {
    var _a = __read(point, 2), x = _a[0], y = _a[1];
    var xInRange = x >= rectangle.x && x <= rectangle.x + rectangle.width;
    var yInRange = y >= rectangle.y && y <= rectangle.y + rectangle.height;
    return xInRange && yInRange;
};
var isInView = function (win) {
    var windowBounds = win.getBounds();
    var nearestWorkArea = Electron.screen.getDisplayMatching(windowBounds).workArea;
    var upperLeftVisible = pointInRectangle([windowBounds.x, windowBounds.y], nearestWorkArea);
    var lowerRightVisible = pointInRectangle([windowBounds.x + windowBounds.width, windowBounds.y + windowBounds.height], nearestWorkArea);
    return upperLeftVisible || lowerRightVisible;
};
exports.WindowUtil = { pointInRectangle: pointInRectangle, isInView: isInView };
//# sourceMappingURL=WindowUtil.js.map