"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var debug = require("debug");
var Electron = require("electron");
var fs = require("fs-extra");
var path = require("path");
var SettingsType_1 = require("./SettingsType");
var app = Electron.app || Electron.remote.app;
var debugLogger = debug('SchemaUpdate');
var defaultPathV0 = path.join(app.getPath('userData'), 'init.json');
var defaultPathV1 = path.join(app.getPath('userData'), 'config/init.json');
var SchemaUpdater = (function () {
    function SchemaUpdater() {
    }
    SchemaUpdater.updateToVersion1 = function (configFileV0, configFileV1) {
        if (configFileV0 === void 0) { configFileV0 = defaultPathV0; }
        if (configFileV1 === void 0) { configFileV1 = defaultPathV1; }
        var config = SchemaUpdater.SCHEMATA.VERSION_1;
        if (fs.existsSync(configFileV0)) {
            try {
                fs.moveSync(configFileV0, configFileV1, { overwrite: true });
                Object.assign(config, fs.readJSONSync(configFileV1));
            }
            catch (error) {
                debugLogger("Could not upgrade \"" + configFileV0 + "\" to \"" + configFileV1 + "\": " + error.message, error);
            }
            var getSetting_1 = function (setting) { return (config.hasOwnProperty(setting) ? config[setting] : undefined); };
            var hasNoConfigVersion = typeof getSetting_1('configVersion') === 'undefined';
            if (hasNoConfigVersion) {
                [SettingsType_1.SettingsType.FULL_SCREEN, SettingsType_1.SettingsType.WINDOW_BOUNDS].forEach(function (setting) {
                    if (typeof getSetting_1(setting) !== 'undefined') {
                        delete config[setting];
                        debugLogger("Deleted \"" + setting + "\" property from old init file.");
                    }
                });
            }
            try {
                fs.writeJsonSync(configFileV1, config, { spaces: 2 });
            }
            catch (error) {
                debugLogger("Failed to write config to \"" + configFileV1 + "\": " + error.message, error);
            }
        }
        return configFileV1;
    };
    SchemaUpdater.SCHEMATA = {
        VERSION_1: {
            configVersion: 1,
        },
    };
    return SchemaUpdater;
}());
exports.SchemaUpdater = SchemaUpdater;
//# sourceMappingURL=SchemaUpdater.js.map