/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.LinkedList;
import java.util.ListIterator;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.diagram.SequenceDiagramDataProvider;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.Fragment;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.message.Answer;

public final class FragmentManager {
    private final SequenceDiagram diagram;
    private final LinkedList<Fragment> openFragments;
    private final LinkedList<Fragment> closingFragments;
    private final LinkedList<String> fragmentLabels;
    private String fragmentSectionLabel;

    public FragmentManager(SequenceDiagram diagram) {
        this.diagram = diagram;
        this.openFragments = new LinkedList();
        this.closingFragments = new LinkedList();
        this.fragmentLabels = new LinkedList();
    }

    public LinkedList<String> getFragmentLabels() {
        return this.fragmentLabels;
    }

    public String getFragmentSectionLabel() {
        return this.fragmentSectionLabel;
    }

    public void clearLabels() {
        this.fragmentLabels.clear();
    }

    public void clearSectionLabel() {
        this.fragmentSectionLabel = null;
    }

    public boolean readFragments() throws SyntaxError {
        SequenceDiagramDataProvider provider = this.diagram.getDataProvider();
        if (provider.closeFragment()) {
            this.closeRecentFragment();
            return true;
        }
        String comment = provider.openFragment();
        if (comment != null) {
            this.fragmentLabels.add(comment);
            return true;
        }
        String newSeparator = provider.getFragmentSeparator();
        if (newSeparator != null) {
            if (this.fragmentSectionLabel != null) {
                throw new SyntaxError(provider, "double separator");
            }
            if (this.getRecentFragment() == null) {
                throw new SyntaxError(provider, "no comment open");
            }
            this.fragmentSectionLabel = newSeparator;
            return true;
        }
        return false;
    }

    public void openFragments() {
        Fragment recent;
        this.finishFragments();
        for (String fragment : this.fragmentLabels) {
            if (fragment.startsWith("[c")) {
                fragment = fragment.substring(2, fragment.length() - 1).trim();
            }
            if (fragment.length() > 0 && fragment.charAt(0) == ':') {
                int s = (fragment = fragment.substring(1)).indexOf(32);
                if (s == -1) {
                    this.openFragment(fragment, "");
                    continue;
                }
                String type = fragment.substring(0, s);
                String name = fragment.substring(s + 1);
                this.openFragment(type, name);
                continue;
            }
            this.openFragment("", fragment);
        }
        if (this.fragmentSectionLabel != null && (recent = this.getRecentFragment()) != null) {
            recent.addSection(this.fragmentSectionLabel);
        }
    }

    private void openFragment(String type, String text) {
        Fragment fragment = new Fragment(type, text, this.diagram);
        int textHeight = this.diagram.getPaintDevice().getTextHeight();
        int extension = 5 + (fragment.getCondition().length() > 0 ? textHeight * 2 : textHeight);
        this.diagram.getPaintDevice().announce(this.diagram.getConfiguration().getFragmentMargin() + extension);
        this.diagram.extendLifelines(this.diagram.getConfiguration().getFragmentMargin());
        fragment.setTop(this.diagram.getVerticalPosition());
        this.diagram.extendLifelines(extension);
        this.openFragments.addLast(fragment);
        this.diagram.getPaintDevice().addExtraordinary(fragment);
        int l = this.openFragments.size() - 1;
        for (Fragment open : this.openFragments) {
            open.setLevel(l);
            --l;
        }
    }

    public boolean openFragmentsExist() {
        return this.openFragments.size() > 0;
    }

    public void finishFragments() {
        for (Fragment comment : this.closingFragments) {
            this.finishFragment(comment);
        }
        this.closingFragments.clear();
    }

    private void finishFragment(Fragment comment) {
        this.diagram.extendLifelines(this.diagram.getConfiguration().getFragmentPadding());
        comment.setBottom(this.diagram.getVerticalPosition());
        this.diagram.extendLifelines(this.diagram.getConfiguration().getFragmentMargin());
    }

    public void finishFragmentsNotIncluding(Answer answer) {
        ListIterator lic = this.closingFragments.listIterator();
        Arrow arrow = answer.getForwardMessage().getArrow();
        while (lic.hasNext()) {
            Fragment comment = (Fragment)lic.next();
            if (comment.containsElement(arrow)) continue;
            lic.remove();
            this.finishFragment(comment);
        }
    }

    public void addSequenceElement(SequenceElement elem) {
        for (Fragment comment : this.openFragments) {
            comment.addElement(elem);
        }
        for (Fragment comment : this.closingFragments) {
            comment.addElement(elem);
        }
    }

    private void closeRecentFragment() throws SyntaxError {
        if (this.openFragments.isEmpty()) {
            throw new SyntaxError(this.diagram.getDataProvider(), "There is no open comment");
        }
        Fragment comment = this.openFragments.removeLast();
        this.closingFragments.addLast(comment);
    }

    private Fragment getRecentFragment() {
        if (this.openFragments.isEmpty()) {
            return null;
        }
        return this.openFragments.getLast();
    }
}

