/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.SvnUtil;

public class UniqueRootsFilter {
    @NotNull
    public <T extends RootUrlPair> List<T> filter(@NotNull List<T> list) {
        if (list == null) {
            UniqueRootsFilter.$$$reportNull$$$0(0);
        }
        ArrayList result = ContainerUtil.newArrayList();
        Collections.sort(list, Comparator.comparing(item -> item.getVirtualFile().getPath()));
        for (RootUrlPair child : list) {
            if (UniqueRootsFilter.alreadyRegistered(child, result)) continue;
            result.add(child);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            UniqueRootsFilter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static <T extends RootUrlPair> boolean alreadyRegistered(@NotNull T child, @NotNull List<T> registered) {
        if (child == null) {
            UniqueRootsFilter.$$$reportNull$$$0(2);
        }
        if (registered == null) {
            UniqueRootsFilter.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(registered, parent -> UniqueRootsFilter.isSamePath(child, parent) || UniqueRootsFilter.isSameSupposedUrl(child, parent));
    }

    private static <T extends RootUrlPair> boolean isSamePath(@NotNull T child, @NotNull T parent) {
        if (child == null) {
            UniqueRootsFilter.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            UniqueRootsFilter.$$$reportNull$$$0(5);
        }
        return parent.getVirtualFile().getPath().equals(child.getVirtualFile().getPath());
    }

    private static <T extends RootUrlPair> boolean isSameSupposedUrl(@NotNull T child, @NotNull T parent) {
        String relativePath;
        if (child == null) {
            UniqueRootsFilter.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            UniqueRootsFilter.$$$reportNull$$$0(7);
        }
        return (relativePath = VfsUtilCore.getRelativePath((VirtualFile)child.getVirtualFile(), (VirtualFile)parent.getVirtualFile(), (char)'/')) != null && relativePath.equals(SvnUtil.getRelativeUrl(parent.getUrl(), child.getUrl()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/UniqueRootsFilter";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registered";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/UniqueRootsFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "alreadyRegistered";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSamePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSameSupposedUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

