/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager.vp;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.vp.BadDataException;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedPresenter;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedView;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

abstract class MembersBasedPresenterImpl<T extends MembersBasedView<?>, M extends MemberInfoModel<PyElement, PyMemberInfo<PyElement>>>
implements MembersBasedPresenter {
    @NotNull
    protected final T myView;
    @NotNull
    protected final PyClass myClassUnderRefactoring;
    @NotNull
    protected final PyMemberInfoStorage myStorage;
    @NotNull
    protected final M myModel;

    MembersBasedPresenterImpl(@NotNull T view, @NotNull PyClass classUnderRefactoring, @NotNull PyMemberInfoStorage infoStorage, @NotNull M model) {
        if (view == null) {
            MembersBasedPresenterImpl.$$$reportNull$$$0(0);
        }
        if (classUnderRefactoring == null) {
            MembersBasedPresenterImpl.$$$reportNull$$$0(1);
        }
        if (infoStorage == null) {
            MembersBasedPresenterImpl.$$$reportNull$$$0(2);
        }
        if (model == null) {
            MembersBasedPresenterImpl.$$$reportNull$$$0(3);
        }
        this.myView = view;
        this.myClassUnderRefactoring = classUnderRefactoring;
        this.myStorage = infoStorage;
        this.myModel = model;
    }

    @Override
    public void okClicked() {
        MultiMap<PyClass, PyMemberInfo<?>> conflicts = this.getConflicts();
        ArrayList dependencyConflicts = new ArrayList();
        for (PyMemberInfo memberInfo : this.myStorage.getClassMemberInfos((PsiElement)this.myClassUnderRefactoring)) {
            if (this.myModel.checkForProblems((MemberInfoBase)memberInfo) == 0) continue;
            dependencyConflicts.add(memberInfo);
        }
        if (conflicts.isEmpty() && dependencyConflicts.isEmpty() || this.myView.showConflictsDialog(conflicts, dependencyConflicts)) {
            try {
                this.validateView();
                this.doRefactor();
            }
            catch (BadDataException e) {
                this.myView.showError(e.getMessage());
            }
        }
    }

    protected void validateView() throws BadDataException {
        if (this.myView.getSelectedMemberInfos().isEmpty()) {
            throw new BadDataException(RefactoringBundle.message((String)"no.members.selected"));
        }
    }

    abstract void doRefactor();

    @NotNull
    protected final MultiMap<PyClass, PyMemberInfo<?>> getConflicts() {
        MultiMap result = new MultiMap();
        Collection<PyMemberInfo<PyElement>> memberInfos = this.myView.getSelectedMemberInfos();
        for (PyClass destinationClass : this.getDestClassesToCheckConflicts()) {
            for (PyMemberInfo<PyElement> pyMemberInfo : memberInfos) {
                if (!pyMemberInfo.hasConflict(destinationClass)) continue;
                result.putValue((Object)destinationClass, pyMemberInfo);
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            MembersBasedPresenterImpl.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @NotNull
    protected abstract Iterable<? extends PyClass> getDestClassesToCheckConflicts();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classUnderRefactoring";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

