/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.JsonProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FieldFilter
extends PathTokenFilter {
    public FieldFilter(String condition) {
        super(condition);
    }

    @Override
    public Object filter(Object obj, JsonProvider jsonProvider, LinkedList<Filter> filters, boolean inArrayContext) {
        if (jsonProvider.isList(obj)) {
            if (!inArrayContext) {
                return null;
            }
            List<Object> result = jsonProvider.createList();
            for (Object current : jsonProvider.toList(obj)) {
                Map<String, Object> map;
                if (!jsonProvider.isMap(current) || !(map = jsonProvider.toMap(current)).containsKey(this.condition)) continue;
                Object o = map.get(this.condition);
                if (jsonProvider.isList(o)) {
                    result.addAll(jsonProvider.toList(o));
                    continue;
                }
                result.add(map.get(this.condition));
            }
            return result;
        }
        Map<String, Object> map = jsonProvider.toMap(obj);
        if (!map.containsKey(this.condition)) {
            throw new InvalidPathException("invalid path");
        }
        return map.get(this.condition);
    }

    @Override
    public Object filter(Object obj, JsonProvider jsonProvider) {
        if (jsonProvider.isList(obj)) {
            return obj;
        }
        return jsonProvider.getMapValue(obj, this.condition);
    }

    @Override
    public Object getRef(Object obj, JsonProvider jsonProvider) {
        return this.filter(obj, jsonProvider);
    }

    @Override
    public boolean isArrayFilter() {
        return false;
    }
}

