/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    @NotNull
    private final TextDiffType myDiffType;

    @NotNull
    public static DiffLineMarkerRenderer createInstance(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            DiffLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        DiffLineMarkerRenderer diffLineMarkerRenderer = new DiffLineMarkerRenderer(diffType);
        if (diffLineMarkerRenderer == null) {
            DiffLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        return diffLineMarkerRenderer;
    }

    private DiffLineMarkerRenderer(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            DiffLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        this.myDiffType = diffType;
    }

    public void paint(Editor editor, Graphics g, Rectangle range2) {
        Color color = this.myDiffType.getPolygonColor(editor);
        if (color == null) {
            return;
        }
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        int y = range2.y;
        int width = gutter.getWidth();
        int height = range2.height;
        if (!this.myDiffType.isApplied()) {
            if (height > 2) {
                g.setColor(color);
                g.fillRect(x, y, width, height);
                DiffUtil.drawDoubleShadowedLine(g2, x, x + width, y - 1, color);
                DiffUtil.drawDoubleShadowedLine(g2, x, x + width, y + height - 1, color);
            } else {
                DiffUtil.drawDoubleShadowedLine(g2, x, x + width, y - 1, color);
            }
        } else {
            DiffUtil.drawBoldDottedFramingLines(g2, x, x + width, y - 1, y + height - 1, color);
        }
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
        if (position == null) {
            DiffLineMarkerRenderer.$$$reportNull$$$0(3);
        }
        return position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/DiffLineMarkerRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

