/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.DefaultPicoContainer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager {
    private final MessageBus myMessageBus;
    private final MutablePicoContainer myPicoContainer;
    private final Map<Class, Object> myComponents;
    private final Set<Object> myDisposableComponents;
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(0);
        }
        this.myMessageBus = MessageBusFactory.newMessageBus((Object)((Object)this));
        this.myComponents = new HashMap<Class, Object>();
        this.myDisposableComponents = ContainerUtil.newConcurrentSet();
        this.myPicoContainer = new DefaultPicoContainer(parent){

            @Nullable
            public Object getComponentInstance(Object componentKey) {
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + (Object)((Object)this));
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }
        };
        this.myPicoContainer.registerComponentInstance((Object)this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && !(o instanceof MessageBus) && this.myDisposableComponents.add(o)) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)o));
        }
    }

    public BaseComponent getComponent(@NotNull String name) {
        if (name == null) {
            MockComponentManager.$$$reportNull$$$0(1);
        }
        return null;
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(2);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(3);
        }
        this.myPicoContainer.unregisterComponent((Object)serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation((Object)serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(4);
        }
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(5);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(6);
        }
        this.myPicoContainer.registerComponentInstance((Object)serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(7);
        }
        if (instance == null) {
            MockComponentManager.$$$reportNull$$$0(8);
        }
        this.myComponents.put(interfaceClass, instance);
        this.registerComponentInDisposer(instance);
    }

    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o;
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(9);
        }
        return (T)((o = this.myPicoContainer.getComponentInstance(interfaceClass)) != null ? o : this.myComponents.get(interfaceClass));
    }

    public <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(10);
        }
        return this.getComponent(interfaceClass);
    }

    public boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(11);
        }
        return false;
    }

    @NotNull
    public <T> T[] getComponents(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            MockComponentManager.$$$reportNull$$$0(12);
        }
        List list2 = this.myPicoContainer.getComponentInstancesOfType(baseClass);
        Object[] objectArray = list2.toArray((Object[])Array.newInstance(baseClass, 0));
        if (objectArray == null) {
            MockComponentManager.$$$reportNull$$$0(13);
        }
        return objectArray;
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            MockComponentManager.$$$reportNull$$$0(14);
        }
        return mutablePicoContainer;
    }

    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            MockComponentManager.$$$reportNull$$$0(15);
        }
        return messageBus;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myMessageBus);
        this.myDisposed = true;
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            MockComponentManager.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException("getExtensions()");
    }

    @NotNull
    public Condition<?> getDisposed() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            MockComponentManager.$$$reportNull$$$0(17);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

