/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiDirectory;
import javax.swing.Icon;

public abstract class TemplateKindProvider {
    private static final ExtensionPointName<TemplateKindProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.javaee.templateKindProvider");

    public static void addAdditionalKinds(AnAction action, PsiDirectory dir, CreateFileFromTemplateDialog.Builder builder2) {
        String id = ActionManager.getInstance().getId(action);
        for (TemplateKindProvider provider : EP_NAME.getExtensionList()) {
            for (Kind kind : provider.getAdditionalKinds(dir)) {
                builder2.addKind(kind.name, kind.icon, kind.templateName);
            }
        }
    }

    public abstract boolean isAvailable(Class<? extends AnAction> var1);

    public abstract Kind[] getAdditionalKinds(PsiDirectory var1);

    public static class Kind {
        public final String name;
        public final String templateName;
        public final Icon icon;

        public Kind(String name, String templateName, Icon icon) {
            this.name = name;
            this.templateName = templateName;
            this.icon = icon;
        }
    }
}

