/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleThreesideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewerEx {
    @NotNull
    private final SimpleThreesideTextDiffProvider myTextDiffProvider;
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleThreesideDiffChange> myInvalidDiffChanges;

    public SimpleThreesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myTextDiffProvider = new SimpleThreesideTextDiffProvider(this.getTextSettings(), this::rediff, (Disposable)this);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        DefaultActionGroup diffGroup = new DefaultActionGroup("Compare Contents", true);
        diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        diffGroup.add((AnAction)Separator.create((String)"Compare Contents"));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_LEFT));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_RIGHT));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT));
        group.add((AnAction)diffGroup);
        group.add((AnAction)Separator.getInstance());
        group.addAll(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyEditorReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        if (indicator == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(4);
        }
        try {
            indicator.checkCanceled();
            List sequences = ContainerUtil.map(this.getContents(), content -> content.getDocument().getImmutableCharSequence());
            List<FineMergeLineFragment> lineFragments = this.myTextDiffProvider.compare((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), indicator);
            runnable2 = this.apply(lineFragments);
        }
        catch (DiffTooBigException e) {
            Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable3 == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(6);
            }
            return runnable3;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
            if (runnable4 == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(7);
            }
            return runnable4;
        }
        if (runnable2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(5);
        }
        return runnable2;
    }

    @NotNull
    private static MergeConflictType invertConflictType(@NotNull MergeConflictType oldConflictType) {
        TextDiffType oldDiffType;
        if (oldConflictType == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(8);
        }
        if ((oldDiffType = oldConflictType.getDiffType()) != TextDiffType.INSERTED && oldDiffType != TextDiffType.DELETED) {
            MergeConflictType mergeConflictType = oldConflictType;
            if (mergeConflictType == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(9);
            }
            return mergeConflictType;
        }
        MergeConflictType mergeConflictType = new MergeConflictType(oldDiffType == TextDiffType.DELETED ? TextDiffType.INSERTED : TextDiffType.DELETED, oldConflictType.isChange(Side.LEFT), oldConflictType.isChange(Side.RIGHT), oldConflictType.canBeResolved());
        if (mergeConflictType == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(10);
        }
        return mergeConflictType;
    }

    @NotNull
    private MergeConflictType convertConflictType(@NotNull FineMergeLineFragment fragment) {
        if (fragment == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(11);
        }
        MergeConflictType conflictType = fragment.getConflictType();
        if (DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.THREESIDE_DIFF_WITH_RESULT) == Boolean.TRUE) {
            conflictType = SimpleThreesideDiffViewer.invertConflictType(conflictType);
        }
        MergeConflictType mergeConflictType = conflictType;
        if (mergeConflictType == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(12);
        }
        return mergeConflictType;
    }

    @NotNull
    private Runnable apply(@NotNull List<FineMergeLineFragment> fragments) {
        if (fragments == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(13);
        }
        Runnable runnable2 = () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            for (FineMergeLineFragment fragment : fragments) {
                MergeConflictType conflictType = this.convertConflictType(fragment);
                MergeInnerDifferences innerFragments = fragment.getInnerFragments();
                SimpleThreesideDiffChange change = new SimpleThreesideDiffChange(fragment, conflictType, innerFragments, this);
                this.myDiffChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(fragments, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
        };
        if (runnable2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(14);
        }
        return runnable2;
    }

    @Override
    protected void destroyChangedBlocks() {
        super.destroyChangedBlocks();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            change.destroy();
        }
        this.myDiffChanges.clear();
        for (SimpleThreesideDiffChange change : this.myInvalidDiffChanges) {
            change.destroy();
        }
        this.myInvalidDiffChanges.clear();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(15);
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        ThreeSide side = ThreeSide.fromValue((List)documents, (Object)e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleThreesideDiffChange> invalid = new ArrayList<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @NotNull
    public List<SimpleThreesideDiffChange> getChanges() {
        List<SimpleThreesideDiffChange> list2 = this.myDiffChanges;
        if (list2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        if (side == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(17);
        }
        MyDividerPaintable myDividerPaintable = new MyDividerPaintable(side);
        if (myDividerPaintable == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(18);
        }
        return myDividerPaintable;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(19);
        }
        if (request == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(20);
        }
        return ThreesideTextDiffViewer.canShowRequest(context, request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConflictType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "invertConflictType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertConflictType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerPaintable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invertConflictType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertConflictType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDividerPaintable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        MyDividerPaintable(Side side) {
            if (side == null) {
                MyDividerPaintable.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MyDividerPaintable.$$$reportNull$$$0(1);
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.isChange(this.mySide) || handler2.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType().getColor(SimpleThreesideDiffViewer.this.getEditor(ThreeSide.BASE)))) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyEditorReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyEditorReadOnlyLockAction() {
            super(SimpleThreesideDiffViewer.this.getContext(), SimpleThreesideDiffViewer.this.getEditableEditors());
        }
    }
}

