/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dialog;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.pdfsam.configuration.StylesConfig;
import org.pdfsam.ui.dialog.ConfirmationDialogContent;
import org.pdfsam.ui.dialog.DialogStyle;
import org.pdfsam.ui.support.Style;

public class ConfirmationDialog
extends Stage {
    private ConfirmationDialogContent dialogContent;
    private boolean response = false;

    public ConfirmationDialog(StylesConfig styles, DialogStyle style, String positiveButtonText, String negativeButtonText) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initStyle(StageStyle.UTILITY);
        this.setResizable(false);
        this.dialogContent = new ConfirmationDialogContent(style.icon);
        VBox containerPane = new VBox();
        containerPane.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.getStyleClass().addAll((Object[])new String[]{"-pdfsam-dialog", style.style});
        HBox buttons = new HBox(new Node[]{this.buildPositiveButton(positiveButtonText, true), this.buildCancelButton(negativeButtonText, false)});
        buttons.getStyleClass().add((Object)"-pdfsam-dialog-buttons");
        containerPane.getChildren().addAll((Object[])new Node[]{this.dialogContent, buttons});
        Scene scene = new Scene((Parent)containerPane);
        scene.getStylesheets().addAll(styles.styles());
        this.setScene(scene);
    }

    public void setOwner(Window owner) {
        this.initOwner(owner);
    }

    ConfirmationDialog title(String title) {
        this.setTitle(title);
        return this;
    }

    ConfirmationDialog messageTitle(String title) {
        this.dialogContent.messageTitle(title);
        return this;
    }

    ConfirmationDialog messageContent(String title) {
        this.dialogContent.messageContent(title);
        return this;
    }

    public boolean response() {
        this.showAndWait();
        return this.response;
    }

    private Button buildButton(String text, boolean response) {
        Button button = new Button(text);
        button.getStyleClass().addAll((Object[])Style.BUTTON.css());
        button.setOnAction(e -> {
            this.response = response;
            this.hide();
        });
        return button;
    }

    private Button buildPositiveButton(String text, boolean response) {
        Button button = this.buildButton(text, response);
        button.setDefaultButton(true);
        return button;
    }

    private Button buildCancelButton(String text, boolean response) {
        Button button = this.buildButton(text, response);
        button.setCancelButton(true);
        return button;
    }
}

