/**
 * The DOMStringList interface provides the abstraction of an ordered collection of DOMString values, without defining or constraining how this collection is implemented. The items in the DOMStringList are accessible via an integral index, starting from 0.
 */
var DOMStringList = {
}
/**
 * Returns the indexth item in the collection. If index is greater than or equal to the number of DOMStrings in the list, this returns null.
 * @syntax dOMStringList.item(index)
 * @param {Number} index Index into the collection.
 * @returns {String} The DOMString at the indexth position in the DOMStringList, or null if that is not a valid index.
 */
DOMStringList.prototype.item = function(index) {};

/**
 * The number of DOMStrings in the list. The range of valid child node indices is 0 to length-1 inclusive.
 * @syntax dOMStringList.length
 * @returns {Number} 
 */
DOMStringList.prototype.length = new Number();

/**
 * Test if a string is part of this DOMStringList.
 * @syntax dOMStringList.contains(str)
 * @param {String} str The string to look for.
 * @returns {boolean} true if the string has been found, false otherwise.
 */
DOMStringList.prototype.contains = function(str) {};

/**
 * Represents the DOMStringList prototype object.
 * @syntax DOMStringList.prototype
 * @static
 */
DOMStringList.prototype;

