/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class ProjectTestRestServicesAction
extends AbstractAction
implements Presenter.Menu,
ContextAwareAction,
LookupListener {
    private String command;
    private ProjectActionPerformer performer;
    private String namePattern;
    private String presenterName;
    private JMenuItem menuPresenter;
    private Lookup lookup;
    private Class<?>[] watch;
    private Lookup.Result[] results;
    private boolean needsRefresh = true;
    private boolean initialized = false;
    private boolean refreshing = false;

    public ProjectTestRestServicesAction() {
        this((Lookup)null);
    }

    private ProjectTestRestServicesAction(Lookup lookup) {
        if (lookup == null) {
            lookup = Utilities.actionsGlobalContext();
        }
        this.lookup = lookup;
        this.watch = new Class[]{Project.class, DataObject.class};
        this.command = "test-restbeans";
        this.presenterName = NbBundle.getMessage(ProjectTestRestServicesAction.class, (String)"LBL_TestRestBeansAction_Name");
        this.setDisplayName(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected final void setDisplayName(String name) {
        this.putValue("Name", name);
    }

    protected void actionPerformed(Lookup context) {
        Project[] projects = Utils.getProjectsFromLookup(context);
        if (projects.length == 1) {
            Utils.testRestWebService(projects[0]);
        }
    }

    protected void refresh(Lookup context) {
        Project[] projects = Utils.getProjectsFromLookup(context);
        if (projects.length == 1) {
            RestSupport restSupport = (RestSupport)projects[0].getLookup().lookup(RestSupport.class);
            if (restSupport == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(restSupport.isRestSupportOn());
            }
        } else {
            this.setEnabled(false);
        }
        this.setLocalizedTextToMenuPresented(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected final void setLocalizedTextToMenuPresented(String presenterName) {
        if (this.menuPresenter != null) {
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)presenterName);
        }
    }

    public JMenuItem getMenuPresenter() {
        if (this.menuPresenter == null) {
            this.menuPresenter = new JMenuItem(this);
            Icon icon = null;
            if (!Boolean.TRUE.equals(this.getValue("noIconInMenu"))) {
                icon = (Icon)this.getValue("SmallIcon");
            }
            this.menuPresenter.setIcon(icon);
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)this.presenterName);
        }
        return this.menuPresenter;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ProjectTestRestServicesAction(actionContext);
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        assert (EventQueue.isDispatchThread()) : "Cannot be called outside EQ!";
        this.results = new Lookup.Result[this.watch.length];
        for (int i = 0; i < this.watch.length; ++i) {
            this.results[i] = this.lookup.lookupResult(this.watch[i]);
            this.results[i].allItems();
            LookupListener resultListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)this.results[i]);
            this.results[i].addLookupListener(resultListener);
        }
        this.initialized = true;
    }

    @Override
    public Object getValue(String key) {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.getValue(key);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.isEnabled();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.init();
        this.actionPerformed(this.lookup);
    }

    protected final Lookup getLookup() {
        return this.lookup;
    }

    private void doRefresh() {
        this.refreshing = true;
        try {
            this.refresh(this.lookup);
        }
        finally {
            this.refreshing = false;
        }
        this.needsRefresh = false;
    }

    public void resultChanged(LookupEvent e) {
        if (this.refreshing) {
            return;
        }
        if (this.getPropertyChangeListeners().length == 0) {
            this.needsRefresh = true;
        } else {
            this.doRefresh();
        }
    }
}

