/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.javaee.project.api.ClientSideDevelopmentSupport;
import org.netbeans.modules.javaee.project.spi.FrameworkServerURLMapping;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.index.ResourcesMappingModel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class JsfServerURLMapping
implements FrameworkServerURLMapping {
    private static final String RESOURCE_DIR = "javax.faces.resource";
    private static final String LIBRARY_PARAM = "ln";
    private static final String CONTRACT_PARAM = "con";
    private static final String RESOURCES = "resources";
    private static final String CONTRACTS = "contracts";

    public FileObject convertURLtoFile(FileObject docRoot, ClientSideDevelopmentSupport.Pattern mapping, String uri, String urlQuery) {
        switch (mapping.getType()) {
            case PREFIX: {
                uri = uri.substring(mapping.getPattern().length());
                break;
            }
            case SUFFIX: {
                uri = uri.substring(0, uri.length() - mapping.getPattern().length());
            }
        }
        if (uri.startsWith("javax.faces.resource/")) {
            String relPath = uri.substring(21);
            try {
                relPath = this.removeSessionIdFromUri(relPath);
                Map<String, String> pairs = JsfServerURLMapping.splitQuery(urlQuery);
                String libraryValue = pairs.get(LIBRARY_PARAM);
                String contractValue = pairs.get(CONTRACT_PARAM);
                if (libraryValue != null) {
                    return docRoot.getFileObject("resources/" + libraryValue + "/" + relPath);
                }
                if (contractValue != null) {
                    return docRoot.getFileObject("contracts/" + contractValue + "/" + relPath);
                }
                return docRoot.getFileObject("resources/" + relPath);
            }
            catch (UnsupportedEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public String convertFileToRelativeURL(FileObject file, String relPath) {
        JsfSupportImpl jsfSupport = JsfSupportImpl.findFor(file);
        if (jsfSupport == null) {
            return relPath;
        }
        String path = file.getPath();
        for (ResourcesMappingModel.Resource resource : jsfSupport.getIndex().getAllStaticResources()) {
            if (!path.contains(resource.getLibrary()) || !path.endsWith(resource.getName())) continue;
            return JsfServerURLMapping.getRelativePathForResource(file, resource, relPath);
        }
        return relPath;
    }

    private static String getRelativePathForResource(FileObject file, ResourcesMappingModel.Resource resource, String relPath) {
        if (resource.getLibrary().isEmpty()) {
            return "javax.faces.resource/" + resource.getName();
        }
        return "javax.faces.resource/" + resource.getLibrary() + "/" + resource.getName();
    }

    private static Map<String, String> splitQuery(String query) throws UnsupportedEncodingException {
        String[] pairs;
        if (query == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            if (idx == -1) continue;
            result.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return result;
    }

    private String removeSessionIdFromUri(String relPath) {
        if (relPath.indexOf(";") != -1) {
            return relPath.substring(0, relPath.indexOf(";"));
        }
        return relPath;
    }
}

