/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;

public final class AsynchronousMethodInvocation {
    private AsynchronousMethodInvocation() {
    }

    public static Collection<ErrorDescription> run(HintContext hintContext) {
        ArrayList<ErrorDescription> problems = new ArrayList<ErrorDescription>();
        EJBProblemContext ctx = HintsUtils.getOrCacheContext(hintContext);
        if (ctx != null && ctx.getEjb() instanceof Session) {
            J2eeProjectCapabilities capabilities = J2eeProjectCapabilities.forProject((Project)ctx.getProject());
            if (capabilities == null || !capabilities.isEjb31LiteSupported() && !capabilities.isEjb32LiteSupported()) {
                return problems;
            }
            ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>();
            for (ExecutableElement method : ElementFilter.methodsIn(ctx.getClazz().getEnclosedElements())) {
                if (!AsynchronousMethodInvocation.isAsynchronousAnnotated(method)) continue;
                candidates.add(method);
            }
            if (candidates.isEmpty()) {
                return problems;
            }
            if (!capabilities.isEjb31Supported() && !capabilities.isEjb32LiteSupported()) {
                for (ExecutableElement method : candidates) {
                    problems.add(HintsUtils.createProblem(method, hintContext.getInfo(), Bundle.AsynchronousMethodInvocation_err_asynchronous_in_ejb31()));
                }
            }
        }
        return problems;
    }

    private static boolean isAsynchronousAnnotated(ExecutableElement method) {
        boolean knownClasses = HintsUtils.isContainingKnownClasses(method);
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            if (!"javax.ejb.Asynchronous".equals(annotationMirror.getAnnotationType().asElement().toString()) || !knownClasses) continue;
            return true;
        }
        return false;
    }
}

