/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public class SubprojectProviderImpl
implements SubprojectProvider {
    private final Project project;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener propChange;

    public SubprojectProviderImpl(Project project) {
        this.project = project;
        this.propChange = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ProjectInfo".equals(evt.getPropertyName())) {
                    SubprojectProviderImpl.this.cs.fireChange();
                }
            }
        };
    }

    public Set<? extends Project> getSubprojects() {
        Collection<File> paths;
        GradleBaseProject gp = GradleBaseProject.get(this.project);
        HashSet<Project> projects = new HashSet<Project>();
        if (gp.isRoot()) {
            paths = gp.getSubProjects().values();
        } else {
            paths = new LinkedList<File>();
            for (GradleDependency.ProjectDependency dep : gp.getProjectDependencies()) {
                paths.add(dep.getPath());
            }
        }
        try {
            for (File projectDir : paths) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                FileObject fo = FileUtil.toFileObject((File)projectDir);
                if (fo == null) continue;
                try {
                    Project p = ProjectManager.getDefault().findProject(fo);
                    if (p == null) continue;
                    projects.add(p);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
        catch (InterruptedException ex) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(projects);
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.cs.hasListeners()) {
            ((NbGradleProject)this.project.getLookup().lookup(NbGradleProject.class)).addPropertyChangeListener(this.propChange);
        }
        this.cs.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.cs.removeChangeListener(cl);
        if (!this.cs.hasListeners()) {
            ((NbGradleProject)this.project.getLookup().lookup(NbGradleProject.class)).removePropertyChangeListener(this.propChange);
        }
    }
}

