/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.GradleArtifactStore;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.spi.GradleFiles;

public final class GradleProjects {
    private GradleProjects() {
    }

    public static File getSources(File binary) {
        return GradleArtifactStore.getDefault().getSources(binary);
    }

    public static File getJavadoc(File binary) {
        return GradleArtifactStore.getDefault().getJavadoc(binary);
    }

    public static Map<String, Project> openedSiblings(Project project) {
        HashMap<String, Project> ret = new HashMap<String, Project>();
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            for (Project openProject : OpenProjects.getDefault().getOpenProjects()) {
                GradleBaseProject test = GradleBaseProject.get(openProject);
                if (test == null || !gbp.isSibling(test)) continue;
                ret.put(test.getName(), openProject);
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    public static Map<String, Project> openedProjectDependencies(Project project) {
        HashMap<String, Project> ret = new HashMap<String, Project>();
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            if (gbp.isRoot()) {
                Map<String, File> subProjects = gbp.getSubProjects();
                for (Project openProject : OpenProjects.getDefault().getOpenProjects()) {
                    GradleBaseProject test = GradleBaseProject.get(openProject);
                    if (test == null || !gbp.isRootOf(test)) continue;
                    ret.put(test.getName(), openProject);
                }
            } else {
                Map<String, Project> siblings = GradleProjects.openedSiblings(project);
                GradleProjects.collectProjectDependencies(ret, siblings, project);
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    public static boolean testForProject(File dir) {
        return new GradleFiles(dir).isProject();
    }

    public static boolean testForRootProject(File dir) {
        return new GradleFiles(dir).isRootProject();
    }

    private static void collectProjectDependencies(Map<String, Project> ret, Map<String, Project> siblings, Project prj) {
        GradleBaseProject gbp = GradleBaseProject.get(prj);
        for (GradleDependency.ProjectDependency dep : gbp.getProjectDependencies()) {
            String id = dep.getId();
            if (ret.containsKey(id) || !siblings.containsKey(id)) continue;
            Project test = siblings.get(id);
            ret.put(id, test);
            GradleProjects.collectProjectDependencies(ret, siblings, test);
        }
    }
}

