/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.gradle.GradleArtifactStore;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;

class GradleBaseProjectBuilder
implements ProjectInfoExtractor.Result {
    static final Map<String, List<String>> DEPENDENCY_TO_PLUGIN = new LinkedHashMap<String, List<String>>();
    final Map<String, Object> info;
    final GradleBaseProject prj = new GradleBaseProject();
    final Set<String> problems = new LinkedHashSet<String>();
    final GradleArtifactStore artifactSore = GradleArtifactStore.getDefault();

    private static void addDependencyPlugin(String dependency, String ... plugins) {
        DEPENDENCY_TO_PLUGIN.put(dependency, Arrays.asList(plugins));
    }

    GradleBaseProjectBuilder(Map<String, Object> info) {
        this.info = info;
    }

    void build() {
        this.processBasicInfo();
        this.processTasks();
        this.processDependencies();
        this.processDependencyPlugins();
    }

    void processBasicInfo() {
        this.prj.name = (String)this.info.get("project_name");
        this.prj.path = (String)this.info.get("project_path");
        this.prj.status = (String)this.info.get("project_status");
        this.prj.parentName = (String)this.info.get("project_parent_name");
        this.prj.displayName = (String)this.info.get("project_display_name");
        this.prj.description = (String)this.info.get("project_description");
        this.prj.group = (String)this.info.get("project_group");
        this.prj.buildDir = (File)this.info.get("project_buildDir");
        this.prj.projectDir = (File)this.info.get("project_projectDir");
        this.prj.rootDir = (File)this.info.get("project_rootDir");
        this.prj.version = (String)this.info.get("project_version");
        this.prj.license = (String)this.info.get("license");
        this.prj.plugins = new TreeSet(this.createSet((Set)this.info.get("plugins")));
        this.prj.subProjects = (Map)this.info.get("project_subProjects");
        this.prj.includedBuilds = (Map)this.info.get("project_includedBuilds");
        if (this.info.containsKey("buildClassPath")) {
            this.prj.buildClassPath = (Set)this.info.get("buildClassPath");
        }
        if (this.info.containsKey("nbprops")) {
            HashMap props = new HashMap((Map)this.info.get("nbprops"));
            this.prj.netBeansProperties = Collections.unmodifiableMap(props);
        }
    }

    void processTasks() {
        Set tasks = (Set)this.info.get("tasks");
        if (tasks != null) {
            for (String[] arr : tasks) {
                GradleTask task = new GradleTask(arr[0], arr[1], arr[2], arr[3]);
                this.prj.tasksByName.put(task.getName(), task);
                List<GradleTask> group = this.prj.tasksByGroup.get(task.getGroup());
                if (group == null) {
                    group = new ArrayList<GradleTask>();
                    this.prj.tasksByGroup.put(task.getGroup(), group);
                }
                group.add(task);
            }
        }
    }

    void processDependencies() {
        HashSet<File> sourceSetOutputs = new HashSet<File>();
        Set sourceSetNames = (Set)this.info.get("sourcesets");
        if (sourceSetNames != null) {
            for (String name : sourceSetNames) {
                Set dirs = (Set)this.info.get("sourceset_" + name + "_output_classes");
                sourceSetOutputs.addAll(dirs);
                sourceSetOutputs.add((File)this.info.get("sourceset_" + name + "_output_resources"));
            }
        }
        this.prj.outputPaths = this.createSet(sourceSetOutputs);
        Set configurationNames = this.createSet((Set)this.info.get("configurations"));
        Map prjs = (Map)this.info.get("project_dependencies");
        prjs = prjs != null ? prjs : Collections.emptyMap();
        Map arts = (Map)this.info.get("resolved_jvm_artifacts");
        arts = arts != null ? arts : Collections.emptyMap();
        Map sources = (Map)this.info.get("resolved_sources_artifacts");
        sources = sources != null ? sources : Collections.emptyMap();
        Map javadocs = (Map)this.info.get("resolved_javadoc_artifacts");
        javadocs = javadocs != null ? javadocs : Collections.emptyMap();
        Map unresolvedProblems = (Map)this.info.get("unresolved_problems");
        unresolvedProblems = unresolvedProblems != null ? unresolvedProblems : Collections.emptyMap();
        HashMap<Object, GradleDependency.ModuleDependency> components = new HashMap<Object, GradleDependency.ModuleDependency>();
        for (Map.Entry entry : arts.entrySet()) {
            GradleDependency.ModuleDependency moduleDependency = new GradleDependency.ModuleDependency((String)entry.getKey(), (Set)entry.getValue());
            components.put(entry.getKey(), moduleDependency);
            moduleDependency.sources = (Set)sources.get(entry.getKey());
            moduleDependency.javadoc = (Set)javadocs.get(entry.getKey());
        }
        HashMap projects = new HashMap();
        for (Map.Entry entry : prjs.entrySet()) {
            GradleDependency dep = new GradleDependency.ProjectDependency((String)entry.getKey(), (File)entry.getValue());
            projects.put(entry.getKey(), (GradleDependency.ProjectDependency)dep);
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : unresolvedProblems.entrySet()) {
            GradleDependency.UnresolvedDependency dep = new GradleDependency.UnresolvedDependency((String)entry.getKey());
            dep.problem = (String)entry.getValue();
            hashMap.put(entry.getKey(), dep);
        }
        if (configurationNames != null) {
            GradleConfiguration conf;
            for (String name : configurationNames) {
                Boolean transitive;
                conf = this.prj.createConfiguration(name);
                conf.modules = new HashSet<GradleDependency.ModuleDependency>();
                Boolean nonResolvingConf = (Boolean)this.info.get("configuration_" + name + "_non_resolving");
                boolean bl = nonResolvingConf != null ? !nonResolvingConf.booleanValue() : (conf.canBeResolved = true);
                if (conf.isCanBeResolved()) {
                    Object c22;
                    Set requiredComponents = (Set)this.info.get("configuration_" + name + "_components");
                    for (Object c22 : requiredComponents) {
                        GradleDependency.ModuleDependency dep = (GradleDependency.ModuleDependency)components.get(c22);
                        if (dep != null) {
                            conf.modules.add(dep);
                            continue;
                        }
                        Set<File> binaries = this.artifactSore.getBinaries((String)c22);
                        if (binaries == null) continue;
                        dep = new GradleDependency.ModuleDependency((String)c22, binaries);
                        components.put(c22, dep);
                        conf.modules.add(dep);
                    }
                    conf.projects = new HashSet<GradleDependency.ProjectDependency>();
                    Set requiredProjects = (Set)this.info.get("configuration_" + name + "_projects");
                    c22 = requiredProjects.iterator();
                    while (c22.hasNext()) {
                        String p = (String)c22.next();
                        conf.projects.add((GradleDependency.ProjectDependency)projects.get(p));
                    }
                    conf.unresolved = new HashSet<GradleDependency.UnresolvedDependency>();
                    Set unresolvedComp = (Set)this.info.get("configuration_" + name + "_unresolved");
                    for (String u : unresolvedComp) {
                        conf.unresolved.add((GradleDependency.UnresolvedDependency)hashMap.get(u));
                    }
                    HashSet files = (HashSet)this.info.get("configuration_" + name + "_files");
                    if (files != null) {
                        files = new HashSet(files);
                        files.removeAll(sourceSetOutputs);
                    }
                    conf.files = new GradleDependency.FileCollectionDependency(this.createSet(files));
                }
                conf.transitive = (transitive = (Boolean)this.info.get("configuration_" + name + "_transitive")) == null ? true : transitive;
                conf.description = (String)this.info.get("configuration_" + name + "_description");
            }
            for (String name : configurationNames) {
                conf = this.prj.configurations.get(name);
                Set extendsFrom = (Set)this.info.get("configuration_" + name + "_extendsFrom");
                HashSet<GradleConfiguration> parents = new HashSet<GradleConfiguration>();
                if (extendsFrom != null) {
                    for (String n : extendsFrom) {
                        parents.add(this.prj.configurations.get(n));
                    }
                }
                conf.extendsFrom = this.createSet(parents);
            }
        }
        for (GradleDependency dep : components.values()) {
            for (File f : ((GradleDependency.ModuleDependency)dep).getArtifacts()) {
                this.prj.componentsByFile.put(f, (GradleDependency.ModuleDependency)dep);
            }
            for (File f : ((GradleDependency.ModuleDependency)dep).getSources()) {
                this.prj.componentsByFile.put(f, (GradleDependency.ModuleDependency)dep);
            }
            for (File f : ((GradleDependency.ModuleDependency)dep).getJavadoc()) {
                this.prj.componentsByFile.put(f, (GradleDependency.ModuleDependency)dep);
            }
        }
        this.problems.addAll(unresolvedProblems.values());
    }

    private void processDependencyPlugins() {
        GradleConfiguration compile = this.prj.configurations.get("compile");
        if (compile != null) {
            Set<GradleConfiguration> parents = compile.getAllParents();
            for (GradleConfiguration config : parents) {
                for (String dependency : DEPENDENCY_TO_PLUGIN.keySet()) {
                    if (config.findModules(dependency).isEmpty()) continue;
                    this.prj.plugins.addAll((Collection<String>)DEPENDENCY_TO_PLUGIN.get(dependency));
                }
            }
        }
    }

    private <T> Set<T> createSet(Set<T> origin) {
        if (origin == null) {
            return Collections.emptySet();
        }
        switch (origin.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(origin.iterator().next());
            }
        }
        return Collections.unmodifiableSet(origin);
    }

    @Override
    public Set getExtract() {
        return Collections.singleton(this.prj);
    }

    @Override
    public Set<String> getProblems() {
        return Collections.unmodifiableSet(this.problems);
    }

    static {
        GradleBaseProjectBuilder.addDependencyPlugin("javax:javaee-api:.*", "ejb", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("javax:javaee-web-api:.*", "ejb", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("javaee:javaee-api:.*", "ejb");
        GradleBaseProjectBuilder.addDependencyPlugin("org.hibernate.javax.persistence:hibernate-jpa-2.0-api:.*", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("org.hibernate.javax.persistence:hibernate-jpa-2.1-api:.*", "jpa");
        GradleBaseProjectBuilder.addDependencyPlugin("org.eclipse.persistence:javax.persistence:.*", "jpa");
    }

    public static final class Extractor
    implements ProjectInfoExtractor {
        @Override
        public ProjectInfoExtractor.Result extract(Map<String, Object> props, Map<Class, Object> otherInfo) {
            GradleBaseProjectBuilder result = new GradleBaseProjectBuilder(props);
            result.build();
            return result;
        }

        @Override
        public ProjectInfoExtractor.Result fallback(GradleFiles files) {
            return new ProjectInfoExtractor.DefaultResult((Object)GradleBaseProject.getFallback(files), new String[0]);
        }
    }
}

