/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class GradleBaseTokenProvider
implements ReplaceTokenProvider {
    private static final Set<String> SUPPORTED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("projectDir", "rootDir", "buildDir", "projectName", "group", "version", "status", "description", "selectedFile", "selectedFileName")));
    final Project project;

    public GradleBaseTokenProvider(Project project) {
        this.project = project;
    }

    @Override
    public Set<String> getSupportedTokens() {
        return SUPPORTED;
    }

    @Override
    public Map<String, String> createReplacements(String action, Lookup context) {
        HashMap<String, String> ret = new HashMap<String, String>();
        GradleBaseProject gbp = GradleBaseProject.get(this.project);
        ret.put("projectDir", gbp.getProjectDir().getAbsolutePath());
        ret.put("rootDir", gbp.getRootDir().getAbsolutePath());
        ret.put("buildDir", gbp.getBuildDir().getAbsolutePath());
        ret.put("projectName", gbp.getName());
        ret.put("group", gbp.getGroup());
        ret.put("version", gbp.getVersion());
        ret.put("status", gbp.getStatus());
        ret.put("description", gbp.getDescription());
        FileObject fo = RunUtils.extractFileObjectfromLookup(context);
        if (fo != null) {
            ret.put("selectedFile", FileUtil.toFile((FileObject)fo).getAbsolutePath());
            ret.put("selectedFileName", fo.getNameExt());
        }
        return ret;
    }
}

