/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.Utils;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectCreateData;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.javaee.project.api.ant.ui.J2EEProjectProperties;
import org.netbeans.spi.java.project.support.PreferredProjectPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppClientProjectGenerator {
    private static final String DEFAULT_CONF_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_BUILD_DIR = "build";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";
    private static final String MANIFEST_FILE = "MANIFEST.MF";

    private AppClientProjectGenerator() {
    }

    @Deprecated
    public static AntProjectHelper createProject(File dir, String name, String mainClass, String j2eeLevel, String serverInstanceID) throws IOException {
        return AppClientProjectGenerator.createProject(dir, name, mainClass, j2eeLevel, serverInstanceID, null);
    }

    @Deprecated
    public static AntProjectHelper createProject(File dir, String name, String mainClass, String j2eeLevel, String serverInstanceID, String librariesDefinition) throws IOException {
        AppClientProjectCreateData createData = new AppClientProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setMainClass(mainClass);
        createData.setJavaEEProfile(Profile.fromPropertiesString((String)j2eeLevel));
        createData.setServerInstanceID(serverInstanceID);
        createData.setLibrariesDefinition(librariesDefinition);
        return AppClientProjectGenerator.createProject(createData);
    }

    public static AntProjectHelper createProject(final AppClientProjectCreateData createData) throws IOException {
        File dir = createData.getProjectDir();
        final AntProjectHelper[] h = new AntProjectHelper[1];
        final FileObject projectDir = FileUtil.createFolder((File)dir);
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = AppClientProjectGenerator.createProjectImpl(createData, projectDir);
            }
        });
        return h[0];
    }

    private static AntProjectHelper createProjectImpl(final AppClientProjectCreateData createData, FileObject projectDir) throws IOException {
        String name = createData.getName();
        String mainClass = createData.getMainClass();
        String serverInstanceID = createData.getServerInstanceID();
        Profile j2eeProfile = createData.getJavaEEProfile();
        FileObject srcRoot = projectDir.createFolder(DEFAULT_SRC_FOLDER);
        FileObject javaRoot = srcRoot.createFolder(DEFAULT_JAVA_FOLDER);
        FileObject confRoot = srcRoot.createFolder(DEFAULT_CONF_FOLDER);
        projectDir.createFolder(DEFAULT_TEST_FOLDER);
        String resource = Profile.JAVA_EE_5.equals(j2eeProfile) ? "org-netbeans-modules-j2ee-clientproject/application-client-5.xml" : (Profile.J2EE_14.equals(j2eeProfile) ? "org-netbeans-modules-j2ee-clientproject/application-client-1.4.xml" : (j2eeProfile != null && j2eeProfile.isAtLeast(Profile.JAVA_EE_7_WEB) ? "org-netbeans-modules-j2ee-clientproject/application-client-7.xml" : "org-netbeans-modules-j2ee-clientproject/application-client-6.xml"));
        FileObject ddFile = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)resource), (FileObject)confRoot, (String)"application-client");
        AppClient appClient = DDProvider.getDefault().getDDRoot(ddFile);
        appClient.setDisplayName(name);
        appClient.write(ddFile);
        if (createData.isCDIEnabled()) {
            DDHelper.createBeansXml((Profile)j2eeProfile, (FileObject)confRoot);
        }
        final AntProjectHelper h = AppClientProjectGenerator.setupProject(projectDir, name, DEFAULT_SRC_FOLDER, DEFAULT_TEST_FOLDER, null, null, null, mainClass, j2eeProfile, serverInstanceID, createData.getLibrariesDefinition(), createData.skipTests());
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.put("source.root", DEFAULT_SRC_FOLDER);
        ep.setProperty("meta.inf", "${source.root}/conf");
        ep.setProperty("src.dir", "${source.root}/java");
        h.putProperties("nbproject/project.properties", ep);
        AppClientProject p = (AppClientProject)ProjectManager.getDefault().findProject(projectDir);
        ProjectManager.getDefault().saveProject((Project)p);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    AppClientProjectGenerator.copyRequiredLibraries(h, refHelper, createData);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex.getException());
        }
        if (mainClass != null) {
            AppClientProjectGenerator.createMainClass(mainClass, javaRoot);
        }
        AppClientProjectGenerator.createManifest(confRoot, MANIFEST_FILE);
        return h;
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File confFolder, File libFolder, String j2eeLevel, String serverInstanceID) throws IOException {
        return AppClientProjectGenerator.importProject(dir, name, sourceFolders, testFolders, confFolder, libFolder, j2eeLevel, serverInstanceID, null);
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File confFolder, File libFolder, String j2eeLevel, String serverInstanceID, String librariesDefinition) throws IOException {
        AppClientProjectCreateData createData = new AppClientProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setSourceFolders(sourceFolders);
        createData.setTestFolders(testFolders);
        createData.setConfFolder(confFolder);
        createData.setLibFolder(libFolder);
        createData.setJavaEEProfile(Profile.fromPropertiesString((String)j2eeLevel));
        createData.setServerInstanceID(serverInstanceID);
        createData.setLibrariesDefinition(librariesDefinition);
        return AppClientProjectGenerator.importProject(createData);
    }

    public static AntProjectHelper importProject(final AppClientProjectCreateData createData) throws IOException {
        File dir = createData.getProjectDir();
        final AntProjectHelper[] h = new AntProjectHelper[1];
        final FileObject projectDir = FileUtil.createFolder((File)dir);
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = AppClientProjectGenerator.importProjectImpl(createData, projectDir);
            }
        });
        return h[0];
    }

    private static AntProjectHelper importProjectImpl(final AppClientProjectCreateData createData, FileObject projectDir) throws IOException {
        FileObject appClientXML;
        final File[] sourceFolders = createData.getSourceFolders();
        final File[] testFolders = createData.getTestFolders();
        String name = createData.getName();
        String serverInstanceID = createData.getServerInstanceID();
        File confFolder = createData.getConfFolder();
        Profile j2eeProfile = createData.getJavaEEProfile();
        assert (sourceFolders != null && testFolders != null) : "Package roots can't be null";
        final AntProjectHelper h = AppClientProjectGenerator.setupProject(projectDir, name, null, null, confFolder, createData.getLibFolder(), null, null, j2eeProfile, serverInstanceID, createData.getLibrariesDefinition(), createData.skipTests());
        final AppClientProject p = (AppClientProject)ProjectManager.getDefault().findProject(projectDir);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties props;
                    Element root;
                    String propName;
                    int i;
                    Element data = h.getPrimaryConfigurationData(true);
                    Document doc = data.getOwnerDocument();
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", "source-roots");
                    assert (nl.getLength() == 1);
                    Element sourceRoots = (Element)nl.item(0);
                    nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/car-project/1", "test-roots");
                    assert (nl.getLength() == 1);
                    Element testRoots = (Element)nl.item(0);
                    for (i = 0; i < sourceFolders.length; ++i) {
                        propName = "src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                        String srcReference = refHelper.createForeignFileReference(sourceFolders[i], AppClientProjectGenerator.DEFAULT_JAVA_FOLDER);
                        root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
                        root.setAttribute("id", propName);
                        sourceRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put(propName, srcReference);
                        h.putProperties("nbproject/project.properties", props);
                    }
                    if (testFolders.length == 0) {
                        EditableProperties props2 = h.getProperties("nbproject/project.properties");
                        props2.put("test.src.dir", "");
                        h.putProperties("nbproject/project.properties", props2);
                    } else {
                        for (i = 0; i < testFolders.length; ++i) {
                            if (!testFolders[i].exists()) {
                                FileUtil.createFolder((File)testFolders[i]);
                            }
                            propName = "test.src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                            String testReference = refHelper.createForeignFileReference(testFolders[i], AppClientProjectGenerator.DEFAULT_JAVA_FOLDER);
                            root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
                            root.setAttribute("id", propName);
                            testRoots.appendChild(root);
                            props = h.getProperties("nbproject/project.properties");
                            props.put(propName, testReference);
                            h.putProperties("nbproject/project.properties", props);
                        }
                    }
                    h.putPrimaryConfigurationData(data, true);
                    AppClientProjectGenerator.copyRequiredLibraries(h, refHelper, createData);
                    ProjectManager.getDefault().saveProject((Project)p);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            IOException ex = new IOException("project creation failed");
            ex.initCause(me);
            throw ex;
        }
        FileObject confFolderFO = FileUtil.toFileObject((File)confFolder);
        FileObject fileObject = appClientXML = confFolderFO == null ? null : confFolderFO.getFileObject("application-client.xml");
        if (appClientXML != null) {
            try {
                String dispName;
                boolean upgradeTo14;
                AppClient root = DDProvider.getDefault().getDDRoot(appClientXML);
                boolean writeDD = false;
                boolean bl = root.getVersion() == null ? true : (upgradeTo14 = new BigDecimal("1.4").compareTo(root.getVersion()) > 0);
                if (upgradeTo14 && Profile.J2EE_14.equals(j2eeProfile)) {
                    root.setVersion(new BigDecimal("1.4"));
                    writeDD = true;
                }
                if (null == (dispName = root.getDefaultDisplayName()) || dispName.trim().length() == 0) {
                    root.setDisplayName(name);
                    writeDD = true;
                }
                if (writeDD) {
                    root.write(appClientXML);
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            String resource = Profile.JAVA_EE_5.equals(j2eeProfile) ? "org-netbeans-modules-j2ee-clientproject/application-client-5.xml" : (Profile.J2EE_14.equals(j2eeProfile) ? "org-netbeans-modules-j2ee-clientproject/application-client-1.4.xml" : (j2eeProfile != null && j2eeProfile.isAtLeast(Profile.JAVA_EE_7_WEB) ? "org-netbeans-modules-j2ee-clientproject/application-client-7.xml" : "org-netbeans-modules-j2ee-clientproject/application-client-6.xml"));
            FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)resource), (FileObject)confFolderFO, (String)"application-client");
        }
        AppClientProjectGenerator.createManifest(confFolderFO, MANIFEST_FILE);
        return h;
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, AppClientProjectCreateData createData) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        if (!createData.skipTests() && rh.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (!createData.skipTests() && rh.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        Profile j2eeProfile = createData.getJavaEEProfile();
        String libraryName = null;
        if (j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || j2eeProfile.equals(Profile.JAVA_EE_6_WEB)) {
            libraryName = "javaee-endorsed-api-6.0";
        }
        if (j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) {
            libraryName = "javaee-endorsed-api-7.0";
        }
        if (libraryName != null && rh.getProjectLibraryManager().getLibrary(libraryName) == null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary(libraryName));
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)h, (ReferenceHelper)rh);
    }

    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File confFolder, File libFolder, String j2eeLevel, String serverInstanceID, boolean fromJavaSource) throws IOException {
        AntProjectHelper h = AppClientProjectGenerator.importProject(dir, name, sourceFolders, testFolders, confFolder, libFolder, j2eeLevel, serverInstanceID);
        EditableProperties subEp = h.getProperties("nbproject/project.properties");
        subEp.setProperty("java.source.based", fromJavaSource + "");
        h.putProperties("nbproject/project.properties", subEp);
        Project subP = ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ProjectManager.getDefault().saveProject(subP);
        return h;
    }

    private static AntProjectHelper setupProject(FileObject dirFO, String name, String srcRoot, String testRoot, File configFiles, File libraries, String resources, String mainClass, Profile j2eeProfile, String serverInstanceID, String librariesDefinition, boolean skipTests) throws IOException {
        String copyProperty;
        String args;
        String jvmOpts;
        String[] stringArray;
        String ref;
        Utils.logUI(NbBundle.getBundle(AppClientProjectGenerator.class), "UI_APP_PROJECT_CREATE_SHARABILITY", new Object[]{librariesDefinition != null, Boolean.FALSE});
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.j2ee.clientproject", (String)librariesDefinition);
        AppClientProject prj = (AppClientProject)ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ReferenceHelper referenceHelper = prj.getReferenceHelper();
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "minimum-ant-version");
        minant.appendChild(doc.createTextNode(MINIMUM_ANT_VERSION));
        data.appendChild(minant);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        EditableProperties epPriv = h.getProperties("nbproject/private/private.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
            root.setAttribute("id", "src.dir");
            root.setAttribute("name", NbBundle.getMessage(AppClientProjectGenerator.class, (String)"NAME_src.dir"));
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/car-project/1", "root");
            root.setAttribute("id", "test.src.dir");
            root.setAttribute("name", NbBundle.getMessage(AppClientProjectGenerator.class, (String)"NAME_test.src.dir"));
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        if (configFiles != null) {
            ref = AppClientProjectGenerator.createFileReference(referenceHelper, dirFO, FileUtil.toFileObject((File)configFiles));
            ep.setProperty("meta.inf", ref);
        }
        if (libraries != null) {
            ref = AppClientProjectGenerator.createFileReference(referenceHelper, dirFO, FileUtil.toFileObject((File)libraries));
            ep.setProperty("lib.dir", ref);
        }
        if (resources != null) {
            ep.setProperty("resource.dir", resources);
        } else {
            ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        }
        ep.setProperty("dist.ear.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("jar.name", PropertyUtils.getUsablePropertyName((String)name) + ".jar");
        ep.setProperty("build.ear.classes.dir", "${build.dir}/jar");
        ep.setProperty("dist.dir", "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}"});
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setProperty("jar.compress", "false");
        if (mainClass != null) {
            ep.setProperty("main.class", mainClass);
        }
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion v = defaultPlatform.getSpecification().getVersion();
        String sourceLevel = v.toString();
        if (sourceLevel.equals("1.7")) {
            sourceLevel = "1.6";
        }
        ep.setProperty("javac.source", sourceLevel);
        ep.setProperty("javac.target", sourceLevel);
        ep.setProperty("javac.deprecation", "false");
        if (skipTests) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "${javac.classpath}:";
            stringArray = stringArray2;
            stringArray2[1] = "${build.classes.dir}";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "${javac.classpath}:";
            stringArray3[1] = "${build.classes.dir}:";
            stringArray3[2] = "${libs.junit.classpath}:";
            stringArray = stringArray3;
            stringArray3[3] = "${libs.junit_4.classpath}";
        }
        ep.setProperty("javac.test.classpath", stringArray);
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/jar");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("run.jvmargs", "");
        ep.setComment("run.jvmargs", new String[]{"# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_run.jvmargs"), "# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_run.jvmargs_2"), "# " + NbBundle.getMessage(AppClientProjectGenerator.class, (String)"COMMENT_run.jvmargs_3")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Deployment deployment = Deployment.getDefault();
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        if (!j2eePlatform.getSupportedProfiles(J2eeModule.Type.CAR).contains(j2eeProfile)) {
            Logger.getLogger("global").log(Level.WARNING, NbBundle.getMessage(AppClientProjectGenerator.class, (String)"MSG_Warning_SpecLevelNotSupported", (Object[])new Object[]{j2eeProfile, Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID)}));
        }
        ep.setProperty("j2ee.platform", j2eeProfile.toPropertiesString());
        ep.setProperty("manifest.file", "${meta.inf}/MANIFEST.MF");
        ep.setProperty("javac.classpath", "");
        J2EEProjectProperties.setServerProperties((EditableProperties)ep, (EditableProperties)epPriv, null, null, (String)serverInstanceID, (Profile)j2eeProfile, (J2eeModule.Type)J2eeModule.Type.CAR);
        AppClientProjectProperties.generateExtraServerProperty(epPriv);
        String mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", "main.class.args");
        if (mainClassArgs != null && !mainClassArgs.equals("")) {
            ep.put("j2ee.appclient.mainclass.args", mainClassArgs);
        } else {
            mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", "j2ee.clientName");
            if (mainClassArgs != null) {
                ep.put("j2ee.clientName", mainClassArgs);
            }
        }
        if (j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || j2eeProfile.equals(Profile.JAVA_EE_6_WEB)) {
            ep.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-6.0.classpath}"});
        }
        if (j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) {
            ep.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-7.0.classpath}"});
        }
        h.putProperties("nbproject/project.properties", ep);
        File[] accrt = j2eePlatform.getToolClasspathEntries("appClientRuntime");
        Map roots = J2EEProjectProperties.extractPlatformLibrariesRoot((J2eePlatform)j2eePlatform);
        epPriv.setProperty("j2ee.appclient.tool.runtime", J2EEProjectProperties.toClasspathString((File[])accrt, (Map)roots));
        String acMain = j2eePlatform.getToolProperty("appClientRuntime", "main.class");
        if (acMain != null) {
            epPriv.setProperty("j2ee.appclient.tool.mainclass", acMain);
        }
        if ((jvmOpts = j2eePlatform.getToolProperty("appClientRuntime", "jvm.opts")) != null) {
            epPriv.setProperty("j2ee.appclient.tool.jvmoptions", jvmOpts);
        }
        if ((args = j2eePlatform.getToolProperty("appClientRuntime", "j2ee.appclient.args")) != null) {
            epPriv.setProperty("j2ee.appclient.tool.args", args);
        }
        if ((copyProperty = j2eePlatform.getToolProperty("appClientRuntime", "client.jar.location")) != null) {
            ep.setProperty("wa.copy.client.jar.from", copyProperty);
        } else {
            ep.remove((Object)"wa.copy.client.jar.from");
        }
        J2EEProjectProperties.createDeploymentScript((FileObject)dirFO, (EditableProperties)ep, (EditableProperties)epPriv, (String)serverInstanceID, (J2eeModule.Type)J2eeModule.Type.CAR);
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        epPriv.setProperty("source.encoding", enc.name());
        h.putProperties("nbproject/private/private.properties", epPriv);
        return h;
    }

    private static String createFileReference(ReferenceHelper refHelper, FileObject projectFO, FileObject referencedFO) {
        String relPath = FileUtil.getRelativePath((FileObject)projectFO, (FileObject)referencedFO);
        if (relPath != null) {
            return relPath;
        }
        return refHelper.createForeignFileReference(FileUtil.toFile((FileObject)referencedFO), null);
    }

    private static void createMainClass(String mainClassName, FileObject srcFolder) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)"Templates/Classes/Main.java");
        if (mainTemplate == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mt.createFromTemplate(pDf, mName);
    }

    public static void setPlatform(final AntProjectHelper helper, final String platformName, final String sourceLevel) {
        FileObject projectDir = helper.getProjectDirectory();
        if (projectDir == null) {
            return;
        }
        try {
            projectDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AppClientProject project = (AppClientProject)ProjectManager.getDefault().findProject(helper.getProjectDirectory());
                                UpdateHelper updateHelper = project.getUpdateHelper();
                                EditableProperties ep = helper.getProperties("nbproject/project.properties");
                                String finalPlatformName = platformName;
                                if (finalPlatformName == null) {
                                    finalPlatformName = PreferredProjectPlatform.getPreferredPlatform((String)JavaPlatform.getDefault().getSpecification().getName()).getDisplayName();
                                }
                                String srcLevel = sourceLevel;
                                if (sourceLevel.equals("1.7")) {
                                    srcLevel = "1.6";
                                }
                                PlatformUiSupport.storePlatform((EditableProperties)ep, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/car-project/1", (String)finalPlatformName, (SpecificationVersion)(srcLevel != null ? new SpecificationVersion(srcLevel) : null));
                                helper.putProperties("nbproject/project.properties", ep);
                                ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(helper.getProjectDirectory()));
                            }
                            catch (IOException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, String path) throws IOException {
        if (dir.getFileObject(path) == null) {
            FileObject manifest = FileUtil.createData((FileObject)dir, (String)path);
            FileLock lock = manifest.lock();
            try {
                OutputStream os = manifest.getOutputStream(lock);
                try {
                    PrintWriter pw = new PrintWriter(os);
                    pw.println("Manifest-Version: 1.0");
                    pw.println("X-COMMENT: Main-Class will be added automatically by build");
                    pw.println();
                    pw.flush();
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
    }
}

