/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;

public final class GradleJavaProject
implements Serializable {
    public static final String CLASSIFIER_NONE = "";
    public static final String CLASSIFIER_TESTS = "tests";
    public static final String CLASSIFIER_JAVADOC = "javadoc";
    public static final String CLASSIFIER_SOURCES = "sources";
    File mainJar;
    Set<File> testClassesRoots;
    Set<File> coverageData;
    Map<String, File> archives;
    transient Map<File, GradleJavaSourceSet> fileToSourceSetCache;
    Map<String, GradleJavaSourceSet> sourceSets = new LinkedHashMap<String, GradleJavaSourceSet>();

    GradleJavaProject() {
    }

    public File getMainJar() {
        return this.mainJar;
    }

    public File getArchive(String classifier) {
        return this.archives != null ? this.archives.get(classifier) : null;
    }

    public Set<File> getCoverageData() {
        return this.coverageData;
    }

    public Set<File> getTestClassesRoots() {
        return this.testClassesRoots;
    }

    public Map<String, GradleJavaSourceSet> getSourceSets() {
        return Collections.unmodifiableMap(this.sourceSets);
    }

    public GradleJavaSourceSet getMainSourceSet() {
        return this.sourceSets.get("main");
    }

    public GradleJavaSourceSet containingSourceSet(File f) {
        GradleJavaSourceSet ret;
        if (this.fileToSourceSetCache == null) {
            this.fileToSourceSetCache = new WeakHashMap<File, GradleJavaSourceSet>();
        }
        if ((ret = this.fileToSourceSetCache.get(f)) == null) {
            for (GradleJavaSourceSet sourceSet : this.sourceSets.values()) {
                if (!sourceSet.contains(f)) continue;
                ret = sourceSet;
                this.fileToSourceSetCache.put(f, ret);
                break;
            }
        }
        return ret;
    }

    protected GradleJavaSourceSet createSourceSet(String name) {
        GradleJavaSourceSet ret = new GradleJavaSourceSet(name);
        this.sourceSets.put(name, ret);
        return ret;
    }

    void resolveSourceSetDependencies() {
        for (GradleJavaSourceSet source : this.sourceSets.values()) {
            if (source.compileClassPath == null) continue;
            for (File cpEntry : source.getCompileClassPath()) {
                for (GradleJavaSourceSet depends : this.sourceSets.values()) {
                    if (depends == source || !depends.outputContains(cpEntry)) continue;
                    if (source.sourceDependencies.isEmpty()) {
                        source.sourceDependencies = new LinkedHashSet<GradleJavaSourceSet>();
                    }
                    source.sourceDependencies.add(depends);
                }
            }
        }
    }

    public static GradleJavaProject get(Project project) {
        NbGradleProject gprj = NbGradleProject.get((Project)project);
        return gprj != null ? (GradleJavaProject)gprj.projectLookup(GradleJavaProject.class) : null;
    }

    static boolean parentOrSame(File f, File supposedParent) {
        if (f == null || supposedParent == null) {
            return false;
        }
        boolean ret = supposedParent.equals(f);
        File sparent = supposedParent.getParentFile();
        for (File parent = f; !ret && parent != null && !parent.equals(sparent); parent = parent.getParentFile()) {
            ret = supposedParent.equals(parent);
        }
        return ret;
    }
}

