/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageFactory;
import java.beans.PropertyEditorSupport;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConverterPropertyEditorBase
extends PropertyEditorSupport {
    protected static final Logger logger = FacesLogger.APPLICATION.getLogger();
    public static final String TARGET_COMPONENT_ATTRIBUTE_NAME = "com.sun.faces.ComponentForValue";

    protected abstract Class<?> getTargetClass();

    protected UIComponent getComponent() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            return (UIComponent)requestMap.get(TARGET_COMPONENT_ATTRIBUTE_NAME);
        }
        return null;
    }

    @Override
    public void setAsText(String textValue) throws IllegalArgumentException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            logger.warning("setAsText: Cannot find FacesContext.");
            throw new FacesException("Cannot find FacesContext.");
        }
        UIComponent component = this.getComponent();
        Class<?> targetClass = this.getTargetClass();
        Converter converter = context.getApplication().createConverter(targetClass);
        if (null == converter) {
            FacesException e = new FacesException("Cannot create Converter to convert value " + textValue + " to instance of target class " + targetClass.getName() + '.');
            logger.warning("setAsText: no faces converter: " + e.getMessage());
            throw e;
        }
        try {
            this.setValue(converter.getAsObject(context, component, textValue));
        }
        catch (ConverterException ce) {
            logger.warning("setAsText: ConverterException: " + ce.getMessage());
            this.addConversionErrorMessage(context, component, ce);
        }
    }

    @Override
    public String getAsText() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            logger.warning("getAsText: Cannot find FacesContext.");
            throw new FacesException("Cannot find FacesContext.");
        }
        UIComponent component = this.getComponent();
        Class<?> targetClass = this.getTargetClass();
        Converter converter = context.getApplication().createConverter(targetClass);
        if (null == converter) {
            throw new FacesException("Cannot create Converter to convert " + targetClass.getName() + " value " + this.getValue() + " to string.");
        }
        try {
            return converter.getAsString(context, component, this.getValue());
        }
        catch (ConverterException ce) {
            this.addConversionErrorMessage(context, component, ce);
            return super.getAsText();
        }
    }

    private void addConversionErrorMessage(FacesContext context, UIComponent component, ConverterException ce) {
        FacesMessage message;
        String converterMessageString = null;
        if (component instanceof UIInput) {
            UIInput input = (UIInput)component;
            converterMessageString = input.getConverterMessage();
            input.setValid(false);
        }
        if (null != converterMessageString) {
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, converterMessageString, converterMessageString);
        } else {
            message = ce.getFacesMessage();
            if (message == null && (message = MessageFactory.getMessage(context, "javax.faces.component.UIInput.CONVERSION", new Object[0])).getDetail() == null) {
                message.setDetail(ce.getMessage());
            }
        }
        context.addMessage(component != null ? component.getClientId(context) : null, message);
    }
}

