/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.GruntBuildTool;
import org.netbeans.modules.javascript.grunt.GruntBuildToolSupport;
import org.netbeans.modules.javascript.grunt.ui.actions.Bundle;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public final class RunGruntTaskAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    static final Logger LOGGER = Logger.getLogger(RunGruntTaskAction.class.getName());
    @NullAllowed
    private final Project project;
    @NullAllowed
    private final FileObject gruntfile;

    public RunGruntTaskAction() {
        this((Project)null);
    }

    private RunGruntTaskAction(Project project) {
        this(project, null);
    }

    private RunGruntTaskAction(Project project, FileObject gruntfile) {
        this.project = project;
        this.gruntfile = gruntfile;
        this.setEnabled(project != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        DataObject dataObject;
        Project contextProject = (Project)context.lookup(Project.class);
        if (contextProject != null) {
            return this.createAction(contextProject);
        }
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null && (dataObject = (DataObject)context.lookup(DataObject.class)) != null) {
            file = dataObject.getPrimaryFile();
        }
        if (file == null) {
            return this;
        }
        contextProject = ProjectConvertors.getNonConvertorOwner((FileObject)file);
        if (contextProject == null) {
            return this;
        }
        if (file.getParent().equals(contextProject.getProjectDirectory())) {
            return this.createAction(contextProject);
        }
        return this.createAction(contextProject, file);
    }

    private Action createAction(Project contextProject) {
        return this.createAction(contextProject, null);
    }

    private Action createAction(Project contextProject, @NullAllowed FileObject gruntfile) {
        assert (contextProject != null);
        GruntBuildTool gruntBuildTool = GruntBuildTool.inProject(contextProject);
        if (gruntBuildTool == null) {
            return this;
        }
        if (gruntfile != null) {
            return new RunGruntTaskAction(contextProject, gruntfile);
        }
        if (!gruntBuildTool.getProjectGruntfile().exists()) {
            return this;
        }
        return new RunGruntTaskAction(contextProject);
    }

    public JMenuItem getPopupPresenter() {
        if (this.project == null) {
            return new Actions.MenuItem((Action)this, false);
        }
        return BuildTools.getDefault().createTasksMenu((BuildTools.TasksMenuSupport)new TasksMenuSupportImpl(this.project, this.gruntfile));
    }

    private static final class TasksMenuSupportImpl
    extends GruntBuildToolSupport
    implements BuildTools.TasksMenuSupport {
        public TasksMenuSupportImpl(Project project, @NullAllowed FileObject gruntfile) {
            super(project, gruntfile);
        }

        public String getTitle(BuildTools.TasksMenuSupport.Title title) {
            switch (title) {
                case MENU: {
                    return Bundle.RunGruntTaskAction_name();
                }
                case LOADING_TASKS: {
                    return Bundle.TasksMenuSupportImpl_tasks_loading();
                }
                case CONFIGURE_TOOL: {
                    return Bundle.TasksMenuSupportImpl_grunt_configure();
                }
                case MANAGE_ADVANCED: {
                    return Bundle.TasksMenuSupportImpl_tasks_manage_advanced();
                }
                case TASKS_LABEL: {
                    return Bundle.TasksMenuSupportImpl_tasks_label();
                }
            }
            assert (false) : "Unknown title: " + title;
            return null;
        }

        public String getDefaultTaskName() {
            return "default";
        }

        public void reloadTasks() {
            assert (!EventQueue.isDispatchThread());
            this.gruntTasks.reset();
            try {
                this.gruntTasks.loadTasks(null, null);
            }
            catch (ExecutionException | TimeoutException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }

        public void configure() {
            OptionsDisplayer.getDefault().open("Html5/Grunt");
        }
    }
}

