/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.context.ApplicationContext;
import org.primefaces.context.DefaultApplicationContext;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.CSVBuilder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.StringEncrypter;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.visit.ResetInputVisitCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestContext
extends RequestContext {
    private static final String ATTRIBUTES_KEY = "ATTRIBUTES";
    private static final String CALLBACK_PARAMS_KEY = "CALLBACK_PARAMS";
    private static final String EXECUTE_SCRIPT_KEY = "EXECUTE_SCRIPT";
    private static final String APPLICATION_CONTEXT_KEY = DefaultApplicationContext.class.getName();
    private Map<Object, Object> attributes;
    private WidgetBuilder widgetBuilder;
    private AjaxRequestBuilder ajaxRequestBuilder;
    private CSVBuilder csvBuilder;
    private FacesContext context;
    private StringEncrypter encrypter;
    private ApplicationContext applicationContext;
    private Boolean ignoreAutoUpdate;
    private Boolean rtl;

    public DefaultRequestContext(FacesContext context) {
        this.context = context;
        this.attributes = new HashMap<Object, Object>();
    }

    @Override
    public boolean isAjaxRequest() {
        return this.context.getPartialViewContext().isAjaxRequest();
    }

    @Override
    public void addCallbackParam(String name, Object value) {
        this.getCallbackParams().put(name, value);
    }

    @Override
    public void execute(String script) {
        this.getScriptsToExecute().add(script);
    }

    @Override
    public Map<String, Object> getCallbackParams() {
        if (this.attributes.get(CALLBACK_PARAMS_KEY) == null) {
            this.attributes.put(CALLBACK_PARAMS_KEY, new HashMap());
        }
        return (Map)this.attributes.get(CALLBACK_PARAMS_KEY);
    }

    @Override
    public List<String> getScriptsToExecute() {
        if (this.attributes.get(EXECUTE_SCRIPT_KEY) == null) {
            this.attributes.put(EXECUTE_SCRIPT_KEY, new ArrayList());
        }
        return (List)this.attributes.get(EXECUTE_SCRIPT_KEY);
    }

    @Override
    public WidgetBuilder getWidgetBuilder() {
        if (this.widgetBuilder == null) {
            this.widgetBuilder = new WidgetBuilder(this.context);
        }
        return this.widgetBuilder;
    }

    @Override
    public AjaxRequestBuilder getAjaxRequestBuilder() {
        if (this.ajaxRequestBuilder == null) {
            this.ajaxRequestBuilder = new AjaxRequestBuilder(this.context);
        }
        return this.ajaxRequestBuilder;
    }

    @Override
    public CSVBuilder getCSVBuilder() {
        if (this.csvBuilder == null) {
            this.csvBuilder = new CSVBuilder(this.context);
        }
        return this.csvBuilder;
    }

    @Override
    public void scrollTo(String clientId) {
        this.execute("PrimeFaces.scrollTo('" + clientId + "');");
    }

    @Override
    public void update(String clientId) {
        this.context.getPartialViewContext().getRenderIds().add(clientId);
    }

    @Override
    public void update(Collection<String> collection) {
        this.context.getPartialViewContext().getRenderIds().addAll(collection);
    }

    @Override
    public void reset(Collection<String> expressions) {
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this.context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        for (String expression : expressions) {
            this.reset(visitContext, expression);
        }
    }

    @Override
    public void reset(String expressions) {
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this.context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        this.reset(visitContext, expressions);
    }

    private void reset(VisitContext visitContext, String expressions) {
        UIViewRoot root = this.context.getViewRoot();
        List<UIComponent> components = SearchExpressionFacade.resolveComponents(this.context, (UIComponent)root, expressions);
        for (UIComponent component : components) {
            component.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
        }
    }

    @Override
    public void openDialog(String outcome) {
        this.getAttributes().put("dialog.outcome", outcome);
    }

    @Override
    public void openDialog(String outcome, Map<String, Object> options, Map<String, List<String>> params) {
        this.getAttributes().put("dialog.outcome", outcome);
        if (options != null) {
            this.getAttributes().put("dialog.options", options);
        }
        if (params != null) {
            this.getAttributes().put("dialog.params", params);
        }
    }

    @Override
    public void closeDialog(Object data) {
        Map params = this.context.getExternalContext().getRequestParameterMap();
        String pfdlgcid = (String)params.get("pfdlgcid");
        if (data != null) {
            Map session = this.context.getExternalContext().getSessionMap();
            session.put(pfdlgcid, data);
        }
        this.execute("parent.PrimeFaces.closeDialog({pfdlgcid:'" + pfdlgcid + "'});");
    }

    @Override
    public void showMessageInDialog(FacesMessage message) {
        this.execute("PrimeFaces.showMessageInDialog({severity:'" + message.getSeverity() + "',summary:'" + message.getSummary() + "',detail:'" + message.getDetail() + "'});");
    }

    @Override
    public void release() {
        DefaultRequestContext.setCurrentInstance(null, this.context);
        this.attributes = null;
        this.widgetBuilder = null;
        this.ajaxRequestBuilder = null;
        this.context = null;
        this.applicationContext = null;
        this.encrypter = null;
    }

    @Override
    public Map<Object, Object> getAttributes() {
        if (this.attributes.get(ATTRIBUTES_KEY) == null) {
            this.attributes.put(ATTRIBUTES_KEY, new HashMap());
        }
        return (Map)this.attributes.get(ATTRIBUTES_KEY);
    }

    @Override
    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = (ApplicationContext)this.context.getExternalContext().getApplicationMap().get(APPLICATION_CONTEXT_KEY);
            if (this.applicationContext == null) {
                this.applicationContext = new DefaultApplicationContext(this.context);
                this.context.getExternalContext().getApplicationMap().put(APPLICATION_CONTEXT_KEY, this.applicationContext);
            }
        }
        return this.applicationContext;
    }

    @Override
    public StringEncrypter getEncrypter() {
        if (this.encrypter == null) {
            this.encrypter = new StringEncrypter(this.getApplicationContext().getConfig().getSecretKey());
        }
        return this.encrypter;
    }

    @Override
    public boolean isSecure() {
        Object request = this.context.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).isSecure();
        }
        try {
            Method method = request.getClass().getDeclaredMethod("isSecure", new Class[0]);
            return (Boolean)method.invoke(request, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isIgnoreAutoUpdate() {
        if (this.ignoreAutoUpdate == null) {
            Object ignoreAutoUpdateObject = this.context.getExternalContext().getRequestParameterMap().get("primefaces.ignoreautoupdate");
            this.ignoreAutoUpdate = null != ignoreAutoUpdateObject && "true".equals(ignoreAutoUpdateObject);
        }
        return this.ignoreAutoUpdate;
    }

    @Override
    public boolean isRTL() {
        if (this.rtl == null) {
            String param = this.context.getExternalContext().getInitParameter("primefaces.DIR");
            if (param == null) {
                this.rtl = false;
            } else {
                ELContext elContext = this.context.getELContext();
                ExpressionFactory expressionFactory = this.context.getApplication().getExpressionFactory();
                ValueExpression expression = expressionFactory.createValueExpression(elContext, param, String.class);
                String expressionValue = (String)expression.getValue(elContext);
                this.rtl = expressionValue == null ? false : expressionValue.equalsIgnoreCase("rtl");
            }
        }
        return this.rtl;
    }
}

