/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public final class GspLexer
implements Lexer<GspTokenId> {
    private final TokenFactory<GspTokenId> tokenFactory;
    private final LexerInput input;
    private LexerState state;

    public GspLexer(LexerRestartInfo<GspTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.state = info.state() == null ? LexerState.INIT : (LexerState)((Object)info.state());
    }

    public Token<GspTokenId> nextToken() {
        GspTokenId tokenId = this.nextTokenId();
        if (tokenId == null) {
            return null;
        }
        return this.tokenFactory.createToken((TokenId)tokenId);
    }

    private GspTokenId nextTokenId() {
        while (true) {
            int actChar;
            if ((actChar = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.state) {
                case INIT: {
                    switch (actChar) {
                        case 60: {
                            this.state = LexerState.LT;
                            break block0;
                        }
                        case 36: {
                            this.state = LexerState.DL;
                            break block0;
                        }
                        case 37: {
                            this.state = LexerState.PC;
                            break block0;
                        }
                        case 62: {
                            return GspTokenId.HTML;
                        }
                        case 10: {
                            return GspTokenId.WHITESPACE;
                        }
                    }
                    break;
                }
                case LT: {
                    switch (actChar) {
                        case 37: {
                            this.state = LexerState.LT_PC;
                            break block0;
                        }
                        case 103: {
                            this.state = LexerState.LT_G;
                            break block0;
                        }
                        case 33: {
                            this.state = LexerState.LT_EM;
                            break block0;
                        }
                        case 47: {
                            this.state = LexerState.LT_BS;
                            break block0;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case DL: {
                    switch (actChar) {
                        case 123: {
                            if (this.isContentRead(2)) {
                                this.state = LexerState.INIT;
                                return GspTokenId.HTML;
                            }
                            this.state = LexerState.GEXPRESSION;
                            return GspTokenId.GSTRING_START;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case PC: {
                    switch (actChar) {
                        case 123: {
                            this.state = LexerState.PC_CB;
                            break block0;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case PC_CB: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.PC_CB_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case PC_CB_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.PC_CB_DOUBLE_DASH;
                            return GspTokenId.COMMENT_GSP_STYLE_START;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case PC_CB_DOUBLE_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.PC_CB_TRIPLE_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.PC_CB_DOUBLE_DASH;
                    break;
                }
                case PC_CB_TRIPLE_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.PC_CB_QUADRUPLE_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.PC_CB_DOUBLE_DASH;
                    break;
                }
                case PC_CB_QUADRUPLE_DASH: {
                    switch (actChar) {
                        case 125: {
                            this.state = LexerState.PC_CB_QUADRUPLE_DASH_CB;
                            break block0;
                        }
                    }
                    this.state = LexerState.PC_CB_DOUBLE_DASH;
                    break;
                }
                case PC_CB_QUADRUPLE_DASH_CB: {
                    switch (actChar) {
                        case 37: {
                            if (this.isContentRead(4)) {
                                this.state = LexerState.PC_CB_DOUBLE_DASH;
                                return GspTokenId.COMMENT_GSP_STYLE_CONTENT;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.COMMENT_GSP_STYLE_END;
                        }
                    }
                    this.state = LexerState.PC_CB_DOUBLE_DASH;
                    break;
                }
                case LT_PC: {
                    switch (actChar) {
                        case 61: {
                            this.state = LexerState.JEXPR;
                            return GspTokenId.SCRIPTLET_OUTPUT_VALUE_START;
                        }
                        case 64: {
                            this.state = LexerState.PAGE_DIRECTIVE;
                            return GspTokenId.PAGE_DIRECTIVE_START;
                        }
                        case 45: {
                            this.state = LexerState.LT_PC_DASH;
                            break block0;
                        }
                    }
                    this.input.backup(1);
                    this.state = LexerState.JSCRIPT;
                    return GspTokenId.SCRIPTLET_START;
                }
                case LT_PC_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.LT_PC_DOUBLE_DASH;
                            return GspTokenId.COMMENT_JSP_STYLE_START;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case LT_PC_DOUBLE_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.LT_PC_TRIPLE_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.LT_PC_DOUBLE_DASH;
                    break;
                }
                case LT_PC_TRIPLE_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.LT_PC_QUADRUPLE_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.LT_PC_DOUBLE_DASH;
                    break;
                }
                case LT_PC_QUADRUPLE_DASH: {
                    switch (actChar) {
                        case 37: {
                            this.state = LexerState.LT_PC_QUADRUPLE_DASH_PC;
                            break block0;
                        }
                    }
                    this.state = LexerState.LT_PC_DOUBLE_DASH;
                    break;
                }
                case LT_PC_QUADRUPLE_DASH_PC: {
                    switch (actChar) {
                        case 62: {
                            if (this.isContentRead(4)) {
                                this.state = LexerState.LT_PC_DOUBLE_DASH;
                                return GspTokenId.COMMENT_JSP_STYLE_CONTENT;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.COMMENT_JSP_STYLE_END;
                        }
                    }
                    this.state = LexerState.LT_PC_DOUBLE_DASH;
                    break;
                }
                case LT_G: {
                    switch (actChar) {
                        case 58: {
                            if (this.isContentRead(3)) {
                                this.state = LexerState.INIT;
                                return GspTokenId.HTML;
                            }
                            this.state = LexerState.GSTART_TAG;
                            return GspTokenId.GTAG_OPENING_START;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case LT_EM: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.LT_EM_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case LT_EM_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.LT_EM_DOUBLE_DASH;
                            return GspTokenId.COMMENT_HTML_STYLE_START;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case LT_EM_DOUBLE_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.LT_EM_TRIPLE_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.LT_EM_DOUBLE_DASH;
                    break;
                }
                case LT_EM_TRIPLE_DASH: {
                    switch (actChar) {
                        case 45: {
                            this.state = LexerState.LT_EM_QUADRUPLE_DASH;
                            break block0;
                        }
                    }
                    this.state = LexerState.LT_EM_DOUBLE_DASH;
                    break;
                }
                case LT_EM_QUADRUPLE_DASH: {
                    switch (actChar) {
                        case 62: {
                            if (this.isContentRead(3)) {
                                this.state = LexerState.LT_EM_DOUBLE_DASH;
                                return GspTokenId.COMMENT_HTML_STYLE_CONTENT;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.COMMENT_HTML_STYLE_END;
                        }
                    }
                    this.state = LexerState.LT_EM_DOUBLE_DASH;
                    break;
                }
                case LT_BS: {
                    switch (actChar) {
                        case 103: {
                            this.state = LexerState.LT_BS_G;
                            break block0;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case LT_BS_G: {
                    switch (actChar) {
                        case 58: {
                            if (this.isContentRead(4)) {
                                this.state = LexerState.INIT;
                                return GspTokenId.HTML;
                            }
                            this.state = LexerState.GEND_TAG;
                            return GspTokenId.GTAG_CLOSING_START;
                        }
                    }
                    this.state = LexerState.INIT;
                    break;
                }
                case GEXPRESSION: {
                    switch (actChar) {
                        case 125: {
                            if (this.isContentRead(1)) {
                                this.state = LexerState.GEXPRESSION;
                                return GspTokenId.GSTRING_CONTENT;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.GSTRING_END;
                        }
                    }
                    this.state = LexerState.GEXPRESSION;
                    break;
                }
                case JEXPR: {
                    switch (actChar) {
                        case 37: {
                            this.state = LexerState.JEXPR_PC;
                            break block0;
                        }
                    }
                    break;
                }
                case JEXPR_PC: {
                    switch (actChar) {
                        case 62: {
                            if (this.isContentRead(2)) {
                                this.state = LexerState.JEXPR;
                                return GspTokenId.SCRIPTLET_OUTPUT_VALUE_CONTENT;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.SCRIPTLET_OUTPUT_VALUE_END;
                        }
                    }
                    this.state = LexerState.JEXPR;
                    break;
                }
                case JSCRIPT: {
                    switch (actChar) {
                        case 37: {
                            this.state = LexerState.JSCRIPT_PC;
                            break block0;
                        }
                    }
                    break;
                }
                case JSCRIPT_PC: {
                    switch (actChar) {
                        case 62: {
                            if (this.isContentRead(2)) {
                                this.state = LexerState.JSCRIPT;
                                return GspTokenId.SCRIPTLET_CONTENT;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.SCRIPTLET_END;
                        }
                    }
                    this.state = LexerState.JSCRIPT;
                    break;
                }
                case PAGE_DIRECTIVE: {
                    switch (actChar) {
                        case 112: {
                            this.state = LexerState.PAGE_DIRECTIVE_P;
                            break block0;
                        }
                        case 37: {
                            this.state = LexerState.PAGE_DIRECTIVE_PC;
                            break block0;
                        }
                    }
                    this.state = LexerState.PAGE_DIRECTIVE;
                    break;
                }
                case PAGE_DIRECTIVE_P: {
                    switch (actChar) {
                        case 97: {
                            this.state = LexerState.PAGE_DIRECTIVE_PA;
                            break block0;
                        }
                    }
                    this.state = LexerState.PAGE_DIRECTIVE;
                    break;
                }
                case PAGE_DIRECTIVE_PA: {
                    switch (actChar) {
                        case 103: {
                            this.state = LexerState.PAGE_DIRECTIVE_PAG;
                            break block0;
                        }
                    }
                    this.state = LexerState.PAGE_DIRECTIVE;
                    break;
                }
                case PAGE_DIRECTIVE_PAG: {
                    switch (actChar) {
                        case 101: {
                            this.state = LexerState.PAGE_DIRECTIVE_WITH_NAME;
                            return GspTokenId.PAGE_DIRECTIVE_NAME;
                        }
                    }
                    this.state = LexerState.PAGE_DIRECTIVE;
                    break;
                }
                case PAGE_DIRECTIVE_WITH_NAME: {
                    switch (actChar) {
                        case 61: {
                            this.state = LexerState.PAGE_DIRECTIVE_WITH_NAME_ATTR;
                            return GspTokenId.PAGE_ATTRIBUTE_NAME;
                        }
                        case 37: {
                            this.state = LexerState.PAGE_DIRECTIVE_PC;
                            break block0;
                        }
                        case 62: {
                            this.state = LexerState.INIT;
                            return GspTokenId.PAGE_DIRECTIVE_END;
                        }
                    }
                    this.state = LexerState.PAGE_DIRECTIVE_WITH_NAME;
                    break;
                }
                case PAGE_DIRECTIVE_WITH_NAME_ATTR: {
                    switch (actChar) {
                        case 32: {
                            this.state = LexerState.PAGE_DIRECTIVE_WITH_NAME;
                            return GspTokenId.PAGE_ATTRIBUTE_VALUE;
                        }
                        case 37: {
                            this.state = LexerState.PAGE_DIRECTIVE_PC;
                        }
                    }
                    break;
                }
                case PAGE_DIRECTIVE_PC: {
                    switch (actChar) {
                        case 62: {
                            if (this.isContentRead(2)) {
                                this.state = LexerState.PAGE_DIRECTIVE_WITH_NAME_ATTR;
                                return GspTokenId.PAGE_ATTRIBUTE_VALUE;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.PAGE_DIRECTIVE_END;
                        }
                    }
                    this.state = LexerState.PAGE_DIRECTIVE;
                    break;
                }
                case GSTART_TAG: {
                    switch (actChar) {
                        case 32: {
                            this.state = LexerState.GSTART_TAG_WITH_NAME;
                            this.input.backup(1);
                            return GspTokenId.GTAG_OPENING_NAME;
                        }
                        case 62: {
                            if (this.isContentRead(1)) {
                                this.state = LexerState.GSTART_TAG;
                                return GspTokenId.GTAG_OPENING_NAME;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_OPENING_END;
                        }
                        case 47: {
                            this.state = LexerState.GINDEPENDENT_TAG;
                            break block0;
                        }
                    }
                    this.state = LexerState.GSTART_TAG;
                    break;
                }
                case GSTART_TAG_WITH_NAME: {
                    switch (actChar) {
                        case 62: {
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_OPENING_END;
                        }
                        case 47: {
                            this.state = LexerState.GINDEPENDENT_TAG_WITH_NAME;
                            break block0;
                        }
                        case 61: {
                            this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR;
                            return GspTokenId.GTAG_ATTRIBUTE_NAME;
                        }
                    }
                    this.state = LexerState.GSTART_TAG_WITH_NAME;
                    break;
                }
                case GSTART_TAG_WITH_NAME_ATTR: {
                    switch (actChar) {
                        case 34: {
                            this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR_VALUE;
                            break block0;
                        }
                        case 62: {
                            if (this.isContentRead(1)) {
                                this.state = LexerState.GSTART_TAG_WITH_NAME;
                                return GspTokenId.GTAG_ATTRIBUTE_VALUE;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_OPENING_END;
                        }
                        case 32: {
                            this.state = LexerState.GSTART_TAG_WITH_NAME;
                            return GspTokenId.GTAG_ATTRIBUTE_VALUE;
                        }
                        case 47: {
                            this.state = LexerState.GINDEPENDENT_TAG_WITH_NAME;
                            return GspTokenId.GTAG_ATTRIBUTE_VALUE;
                        }
                    }
                    this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR;
                    break;
                }
                case GSTART_TAG_WITH_NAME_ATTR_VALUE: {
                    switch (actChar) {
                        case 34: {
                            this.state = LexerState.GSTART_TAG_WITH_NAME;
                            return GspTokenId.GTAG_ATTRIBUTE_VALUE;
                        }
                        case 92: {
                            this.state = LexerState.GSTART_TAG_BACKSLASH;
                            break block0;
                        }
                        case 36: {
                            this.state = LexerState.GSTART_TAG_EXPR;
                            break block0;
                        }
                        case 47: {
                            this.state = LexerState.GINDEPENDENT_TAG_WITH_NAME;
                            return GspTokenId.GTAG_ATTRIBUTE_VALUE;
                        }
                    }
                    break;
                }
                case GEND_TAG: {
                    switch (actChar) {
                        case 32: {
                            this.state = LexerState.GEND_TAG_WITH_NAME;
                            return GspTokenId.GTAG_CLOSING_NAME;
                        }
                        case 62: {
                            if (this.isContentRead(1)) {
                                this.state = LexerState.GEND_TAG;
                                return GspTokenId.GTAG_CLOSING_NAME;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_CLOSING_END;
                        }
                    }
                    this.state = LexerState.GEND_TAG;
                    break;
                }
                case GEND_TAG_WITH_NAME: {
                    switch (actChar) {
                        case 62: {
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_CLOSING_END;
                        }
                    }
                    this.state = LexerState.GEND_TAG_WITH_NAME;
                    break;
                }
                case GINDEPENDENT_TAG: {
                    switch (actChar) {
                        case 62: {
                            if (this.isContentRead(2)) {
                                this.state = LexerState.GSTART_TAG;
                                return GspTokenId.GTAG_OPENING_NAME;
                            }
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_INDEPENDENT_END;
                        }
                    }
                    this.state = LexerState.GSTART_TAG;
                    break;
                }
                case GINDEPENDENT_TAG_WITH_NAME: {
                    switch (actChar) {
                        case 62: {
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_INDEPENDENT_END;
                        }
                    }
                    this.state = LexerState.GSTART_TAG_WITH_NAME;
                    break;
                }
                case GSTART_TAG_BACKSLASH: {
                    switch (actChar) {
                        case 36: {
                            this.state = LexerState.GSTART_TAG_BACKSLASH_EXPR;
                            break block0;
                        }
                    }
                    this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR_VALUE;
                    break;
                }
                case GSTART_TAG_BACKSLASH_EXPR: {
                    switch (actChar) {
                        case 123: {
                            if (this.isContentRead(3)) {
                                this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR_VALUE;
                                return GspTokenId.GTAG_ATTRIBUTE_VALUE;
                            }
                            this.state = LexerState.GSTART_TAG_EXPR_PC;
                            return GspTokenId.GSTRING_START;
                        }
                    }
                    break;
                }
                case GSTART_TAG_EXPR: {
                    switch (actChar) {
                        case 123: {
                            if (this.isContentRead(2)) {
                                this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR_VALUE;
                                return GspTokenId.GTAG_ATTRIBUTE_VALUE;
                            }
                            this.state = LexerState.GSTART_TAG_EXPR_PC;
                            return GspTokenId.GSTRING_START;
                        }
                    }
                    this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR_VALUE;
                    break;
                }
                case GSTART_TAG_EXPR_PC: {
                    switch (actChar) {
                        case 125: {
                            if (this.isContentRead(1)) {
                                this.state = LexerState.GSTART_TAG_EXPR_PC;
                                return GspTokenId.GSTRING_CONTENT;
                            }
                            this.state = LexerState.GSTART_TAG_WITH_NAME_ATTR_VALUE;
                            return GspTokenId.GSTRING_END;
                        }
                        case 62: {
                            this.state = LexerState.INIT;
                            return GspTokenId.GTAG_OPENING_START;
                        }
                    }
                    this.state = LexerState.GSTART_TAG_EXPR_PC;
                }
            }
        }
        this.input.backup(1);
        switch (this.state) {
            case JSCRIPT: {
                return GspTokenId.GSTRING_CONTENT;
            }
            case GEXPRESSION: {
                return GspTokenId.GSTRING_CONTENT;
            }
            case PAGE_DIRECTIVE: {
                return GspTokenId.PAGE_DIRECTIVE_START;
            }
            case LT_EM_DOUBLE_DASH: {
                return GspTokenId.COMMENT_HTML_STYLE_START;
            }
            case LT_PC_DOUBLE_DASH: {
                return GspTokenId.COMMENT_JSP_STYLE_START;
            }
            case PC_CB_DOUBLE_DASH: {
                return GspTokenId.COMMENT_GSP_STYLE_START;
            }
        }
        return GspTokenId.ERROR;
    }

    private boolean isContentRead(int endTokenLength) {
        if (this.input.readLength() > endTokenLength) {
            this.input.backup(endTokenLength);
            return true;
        }
        return false;
    }

    public Object state() {
        return this.state;
    }

    public void release() {
    }

    private static enum LexerState {
        INIT,
        LT,
        DL,
        GEXPRESSION,
        LT_G,
        GSTART_TAG,
        GSTART_TAG_WITH_NAME,
        GSTART_TAG_WITH_NAME_ATTR,
        GSTART_TAG_WITH_NAME_ATTR_VALUE,
        GSTART_TAG_EXPR,
        GSTART_TAG_EXPR_PC,
        GSTART_TAG_BACKSLASH,
        GSTART_TAG_BACKSLASH_EXPR,
        GINDEPENDENT_TAG,
        GINDEPENDENT_TAG_WITH_NAME,
        LT_BS,
        LT_BS_G,
        GEND_TAG,
        GEND_TAG_WITH_NAME,
        PC,
        PC_CB,
        PC_CB_DASH,
        PC_CB_DOUBLE_DASH,
        PC_CB_TRIPLE_DASH,
        PC_CB_QUADRUPLE_DASH,
        PC_CB_QUADRUPLE_DASH_CB,
        LT_EM,
        LT_EM_DASH,
        LT_EM_DOUBLE_DASH,
        LT_EM_TRIPLE_DASH,
        LT_EM_QUADRUPLE_DASH,
        LT_PC_DASH,
        LT_PC_DOUBLE_DASH,
        LT_PC_TRIPLE_DASH,
        LT_PC_QUADRUPLE_DASH,
        LT_PC_QUADRUPLE_DASH_PC,
        PAGE_DIRECTIVE,
        PAGE_DIRECTIVE_P,
        PAGE_DIRECTIVE_PA,
        PAGE_DIRECTIVE_PAG,
        PAGE_DIRECTIVE_WITH_NAME,
        PAGE_DIRECTIVE_WITH_NAME_ATTR,
        PAGE_DIRECTIVE_PC,
        LT_PC,
        JSCRIPT,
        JSCRIPT_PC,
        JEXPR,
        JEXPR_PC;

    }
}

