/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTFileSystem;
import org.openide.util.BaseUtilities;

public final class NBJRTFileSystemProvider {
    private static final Logger LOG = Logger.getLogger(NBJRTFileSystemProvider.class.getName());
    private static final NBJRTFileSystemProvider INSTANCE = new NBJRTFileSystemProvider();
    private final Map<File, NBJRTFileSystem> javaHome2JRTFS = Collections.synchronizedMap(new HashMap());

    private NBJRTFileSystemProvider() {
    }

    @CheckForNull
    NBJRTFileSystem getFileSystem(@NonNull URL jdkHome) {
        try {
            return this.getFileSystem(BaseUtilities.toFile((URI)jdkHome.toURI()));
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Invalid URI: {0}", jdkHome);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    NBJRTFileSystem getFileSystem(@NonNull File jdkHome) {
        Map<File, NBJRTFileSystem> map = this.javaHome2JRTFS;
        synchronized (map) {
            NBJRTFileSystem fs = this.javaHome2JRTFS.get(jdkHome);
            if (fs == null && !this.javaHome2JRTFS.containsKey(jdkHome)) {
                fs = NBJRTFileSystem.create(jdkHome);
                this.javaHome2JRTFS.put(jdkHome, fs);
            }
            return fs;
        }
    }

    public static NBJRTFileSystemProvider getDefault() {
        return INSTANCE;
    }
}

