/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    @Override
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        RawMessage rawMessage;
        DefaultRequest<SendRawEmailRequest> request = new DefaultRequest<SendRawEmailRequest>(sendRawEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        if (sendRawEmailRequest != null && sendRawEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendRawEmailRequest.getSource()));
        }
        if (sendRawEmailRequest != null) {
            List<String> destinationsList = sendRawEmailRequest.getDestinations();
            int destinationsListIndex = 1;
            for (String destinationsListValue : destinationsList) {
                if (destinationsListValue != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex, StringUtils.fromString(destinationsListValue));
                }
                ++destinationsListIndex;
            }
        }
        if (sendRawEmailRequest != null && (rawMessage = sendRawEmailRequest.getRawMessage()) != null && rawMessage.getData() != null) {
            request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer(rawMessage.getData()));
        }
        return request;
    }
}

