/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    @Override
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        DefaultRequest<SendEmailRequest> request = new DefaultRequest<SendEmailRequest>(sendEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        if (sendEmailRequest != null && sendEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendEmailRequest.getSource()));
        }
        if (sendEmailRequest != null) {
            Destination destination = sendEmailRequest.getDestination();
            if (destination != null) {
                List<String> toAddressesList = destination.getToAddresses();
                int toAddressesListIndex = 1;
                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString(toAddressesListValue));
                    }
                    ++toAddressesListIndex;
                }
            }
            if (destination != null) {
                List<String> ccAddressesList = destination.getCcAddresses();
                int ccAddressesListIndex = 1;
                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString(ccAddressesListValue));
                    }
                    ++ccAddressesListIndex;
                }
            }
            if (destination != null) {
                List<String> bccAddressesList = destination.getBccAddresses();
                int bccAddressesListIndex = 1;
                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString(bccAddressesListValue));
                    }
                    ++bccAddressesListIndex;
                }
            }
        }
        if (sendEmailRequest != null) {
            Message message = sendEmailRequest.getMessage();
            if (message != null) {
                Content subject = message.getSubject();
                if (subject != null && subject.getData() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString(subject.getData()));
                }
                if (subject != null && subject.getCharset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString(subject.getCharset()));
                }
            }
            if (message != null) {
                Body body = message.getBody();
                if (body != null) {
                    Content text = body.getText();
                    if (text != null && text.getData() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString(text.getData()));
                    }
                    if (text != null && text.getCharset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString(text.getCharset()));
                    }
                }
                if (body != null) {
                    Content html = body.getHtml();
                    if (html != null && html.getData() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString(html.getData()));
                    }
                    if (html != null && html.getCharset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString(html.getCharset()));
                    }
                }
            }
        }
        if (sendEmailRequest != null) {
            List<String> replyToAddressesList = sendEmailRequest.getReplyToAddresses();
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString(replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendEmailRequest != null && sendEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendEmailRequest.getReturnPath()));
        }
        return request;
    }
}

