/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAttributesRequest
extends AmazonWebServiceRequest {
    private String domainName;
    private String itemName;
    private List<Attribute> attributes;
    private UpdateCondition expected;

    public DeleteAttributesRequest() {
    }

    public DeleteAttributesRequest(String domainName, String itemName) {
        this.domainName = domainName;
        this.itemName = itemName;
    }

    public DeleteAttributesRequest(String domainName, String itemName, List<Attribute> attributes) {
        this.domainName = domainName;
        this.itemName = itemName;
        this.attributes = attributes;
    }

    public DeleteAttributesRequest(String domainName, String itemName, List<Attribute> attributes, UpdateCondition expected) {
        this.domainName = domainName;
        this.itemName = itemName;
        this.attributes = attributes;
        this.expected = expected;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DeleteAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public DeleteAttributesRequest withItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        ArrayList<Attribute> attributesCopy = new ArrayList<Attribute>();
        if (attributes != null) {
            attributesCopy.addAll(attributes);
        }
        this.attributes = attributesCopy;
    }

    public DeleteAttributesRequest withAttributes(Attribute ... attributes) {
        for (Attribute value : attributes) {
            this.getAttributes().add(value);
        }
        return this;
    }

    public DeleteAttributesRequest withAttributes(Collection<Attribute> attributes) {
        ArrayList<Attribute> attributesCopy = new ArrayList<Attribute>();
        if (attributes != null) {
            attributesCopy.addAll(attributes);
        }
        this.attributes = attributesCopy;
        return this;
    }

    public UpdateCondition getExpected() {
        return this.expected;
    }

    public void setExpected(UpdateCondition expected) {
        this.expected = expected;
    }

    public DeleteAttributesRequest withExpected(UpdateCondition expected) {
        this.expected = expected;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("DomainName: " + this.domainName + ", ");
        sb.append("ItemName: " + this.itemName + ", ");
        sb.append("Attributes: " + this.attributes + ", ");
        sb.append("Expected: " + this.expected + ", ");
        sb.append("}");
        return sb.toString();
    }
}

