/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.jade.editor.lexer.JadeTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class JadeHtmlEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOGGER = Logger.getLogger(JadeHtmlEmbeddingProvider.class.getName());
    private static final String HTML_MIME_TYPE = "text/html";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JadeTokenId.jadeLanguage());
        if (ts == null) {
            LOGGER.log(Level.WARNING, "TokenHierarchy.tokenSequence(JadeTokenId.jadeLanguage()) == null for static immutable Jade TokenHierarchy!\nFile = ''{0}'' ;snapshot mimepath=''{1}''", new Object[]{snapshot.getSource().getFileObject().getPath(), snapshot.getMimePath()});
            return Collections.emptyList();
        }
        ts.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int from = -1;
        int len = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (token.id() == JadeTokenId.PLAIN_TEXT) {
                if (from < 0) {
                    from = ts.offset();
                }
                len += token.length();
                continue;
            }
            if (from >= 0) {
                embeddings.add(snapshot.create(from, len + 1, HTML_MIME_TYPE));
            }
            from = -1;
            len = 0;
        }
        if (from >= 0) {
            embeddings.add(snapshot.create(from, len, HTML_MIME_TYPE));
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 201;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new JadeHtmlEmbeddingProvider());
        }
    }
}

