/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsps.parserapi.TldChangeEvent;
import org.netbeans.modules.web.jsps.parserapi.TldChangeListener;
import org.openide.util.Exceptions;

public class TldChangeSupport {
    private final List<TldChangeListener> listeners = new CopyOnWriteArrayList<TldChangeListener>();
    private final Object source;

    public TldChangeSupport(Object source) {
        this.source = source;
    }

    public void addTldChangeListener(TldChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeTldChangeListener(TldChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void fireChange(WebModule webModule) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireChange(new TldChangeEvent(this.source, webModule));
    }

    private void fireChange(TldChangeEvent event) {
        assert (event != null);
        for (TldChangeListener listener : this.listeners) {
            try {
                listener.tldChange(event);
            }
            catch (RuntimeException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }
}

