/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    private static final String ENABED = "enabled";
    private static final String FUNC_NAME = "functionName";
    private static final String TYPE = "type";
    private static final String GROUP_NAME = "groupName";

    public String[] getSupportedClassNames() {
        return new String[]{LineBreakpoint.class.getName(), FunctionBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        if (typeID.equals(LineBreakpoint.class.getName())) {
            Line line = this.getLine(properties.getString("url", null), properties.getInt("lineNumber", 1));
            if (line == null) {
                return null;
            }
            LineBreakpoint breakpoint = new LineBreakpoint(line);
            if (!properties.getBoolean(ENABED, true)) {
                breakpoint.disable();
            }
            breakpoint.setGroupName(properties.getString(GROUP_NAME, ""));
            breakpoint.setCondition(properties.getString("condition", null));
            return breakpoint;
        }
        if (typeID.equals(FunctionBreakpoint.class.getName())) {
            String func = properties.getString(FUNC_NAME, null);
            FunctionBreakpoint.Type type = FunctionBreakpoint.Type.forString(properties.getString(TYPE, null));
            if (func == null || type == null) {
                return null;
            }
            FunctionBreakpoint breakpoint = new FunctionBreakpoint(type, func);
            if (!properties.getBoolean(ENABED, true)) {
                breakpoint.disable();
            }
            breakpoint.setGroupName(properties.getString(GROUP_NAME, ""));
            return breakpoint;
        }
        return null;
    }

    public void write(Object object, Properties properties) {
        if (object instanceof LineBreakpoint) {
            LineBreakpoint breakpoint = (LineBreakpoint)((Object)object);
            FileObject fileObject = (FileObject)breakpoint.getLine().getLookup().lookup(FileObject.class);
            properties.setString("url", fileObject.toURL().toString());
            properties.setInt("lineNumber", breakpoint.getLine().getLineNumber());
            properties.setBoolean(ENABED, breakpoint.isEnabled());
            properties.setString(GROUP_NAME, breakpoint.getGroupName());
            properties.setString("condition", breakpoint.getCondition());
        } else if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint breakpoint = (FunctionBreakpoint)((Object)object);
            String func = breakpoint.getFunction();
            properties.setString(FUNC_NAME, func);
            properties.setString(TYPE, breakpoint.getType().toString());
            properties.setBoolean(ENABED, breakpoint.isEnabled());
            properties.setString(GROUP_NAME, breakpoint.getGroupName());
        }
    }

    private Line getLine(String url, int lineNumber) {
        FileObject file = this.getFileObject(url);
        if (file == null) {
            return null;
        }
        return Utils.getLine(file, lineNumber);
    }

    private FileObject getFileObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return file;
    }
}

