/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandException;
import org.netbeans.modules.glassfish.tooling.admin.CommandRestoreDomain;
import org.netbeans.modules.glassfish.tooling.admin.ProcessIOContent;
import org.netbeans.modules.glassfish.tooling.admin.RunnerAsadmin;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.OsUtils;

public class RunnerAsadminRestoreDomain
extends RunnerAsadmin {
    private static final Logger LOGGER = new Logger(RunnerAsadminRestoreDomain.class);
    private static final String DOMAIN_DIR_PARAM = "--domaindir";
    private static final String BACKUP_DIR_PARAM = "--backupdir";
    private static final String BACKUP_FILE_PARAM = "--filename";
    private static final String FORCE_PARAM = "--force";
    final CommandRestoreDomain command;

    private static String query(GlassFishServer server, Command command) {
        String METHOD = "query";
        String domainsFolder = OsUtils.escapeString(server.getDomainsFolder());
        String domainName = OsUtils.escapeString(server.getDomainName());
        if (domainName == null || domainsFolder == null) {
            throw new CommandException(LOGGER.excMsg("query", "nullValue"));
        }
        if (!(command instanceof CommandRestoreDomain)) {
            throw new CommandException(LOGGER.excMsg("query", "illegalInstance"));
        }
        CommandRestoreDomain restoreCommand = (CommandRestoreDomain)command;
        StringBuilder sb = new StringBuilder();
        sb.append(DOMAIN_DIR_PARAM);
        sb.append(' ');
        sb.append(domainsFolder);
        sb.append(' ');
        sb.append(FORCE_PARAM);
        sb.append(' ');
        sb.append(BACKUP_FILE_PARAM);
        sb.append(' ');
        sb.append(restoreCommand.domainBackup.getAbsolutePath());
        sb.append(' ');
        sb.append(domainName);
        System.out.println("Restore command params: " + sb.toString());
        return sb.toString();
    }

    public RunnerAsadminRestoreDomain(GlassFishServer server, Command command) {
        super(server, command, RunnerAsadminRestoreDomain.query(server, command));
        String METHOD = "init";
        if (!(command instanceof CommandRestoreDomain)) {
            throw new CommandException(LOGGER.excMsg("init", "illegalInstance"));
        }
        this.command = (CommandRestoreDomain)command;
    }

    @Override
    protected ProcessIOContent createProcessIOContent() {
        ProcessIOContent processIOContent = new ProcessIOContent();
        processIOContent.addOutput(new String[]{"Command", "executed successfully"}, new String[]{"Command restore-domain failed"});
        return processIOContent;
    }
}

