/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.modules.j2ee.sun.validation.Validatee;
import org.netbeans.modules.j2ee.sun.validation.Validator;
import org.netbeans.modules.j2ee.sun.validation.constraints.CardinalConstraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.data.Argument;
import org.netbeans.modules.j2ee.sun.validation.constraints.data.Arguments;
import org.netbeans.modules.j2ee.sun.validation.constraints.data.CheckInfo;
import org.netbeans.modules.j2ee.sun.validation.constraints.data.Constraints;
import org.netbeans.modules.j2ee.sun.validation.data.Check;
import org.netbeans.modules.j2ee.sun.validation.data.Element;
import org.netbeans.modules.j2ee.sun.validation.data.Parameter;
import org.netbeans.modules.j2ee.sun.validation.data.Parameters;
import org.netbeans.modules.j2ee.sun.validation.data.Validation;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;
import org.netbeans.modules.j2ee.sun.validation.util.ObjectFactory;
import org.netbeans.modules.j2ee.sun.validation.util.Utils;

public class ValidationManager {
    private static String GET_PREFIX = "get";
    private static String SET_PREFIX = "set";
    private static String SIZE_PREFIX = "size";
    private static final String defaultConstraintsFile = "org/netbeans/modules/j2ee/sun/validation/constraints/constraints.xml";
    private static final String CARDINAL_CONSTRAINT_CLASS = "org.netbeans.modules.j2ee.sun.validation.constraints.CardinalConstraint";
    private String validationFile = null;
    private String defaultValidationFile = "org/netbeans/modules/j2ee/sun/validation/validation.xml";
    private HashMap xpathToValidator = null;
    private Validation validation = null;
    private Constraints constraints = null;
    private Utils utils = null;

    public ValidationManager() {
        this.utils = new Utils();
    }

    public ValidationManager(String validationFile) {
        if (null != validationFile) {
            this.validationFile = validationFile;
        }
        this.utils = new Utils();
    }

    public Collection validate(Object object) {
        Collection collection = new ArrayList();
        if (object != null) {
            boolean validateeImplFound = false;
            String validateeImpl = null;
            String implFile = System.getProperty("impl.file");
            if (implFile != null) {
                validateeImpl = this.getValidateeImplementation(object, implFile);
            }
            if (validateeImpl == null) {
                validateeImpl = this.getValidateeImplementation(object, "org.netbeans.modules.j2ee.sun.validation.impl.Impl");
            }
            BundleReader.setBundle("org.netbeans.modules.j2ee.sun.validation.Bundle");
            if (validateeImpl != null) {
                Validatee validatee = (Validatee)ObjectFactory.newInstance(validateeImpl, object);
                if (validatee != null) {
                    collection = this.validate(validatee);
                }
            } else {
                Class classObject = this.utils.getClass(object);
                String className = classObject.getName();
                String format = BundleReader.getValue("MSG_given_object_is_not_validatee");
                Object[] arguments = new Object[]{className};
                System.out.println(MessageFormat.format(format, arguments));
            }
        }
        return collection;
    }

    public Collection validate(Validatee validatee) {
        ArrayList failures = new ArrayList();
        if (validatee != null) {
            String xpath = validatee.getXPath();
            ArrayList elementNames = validatee.getElementNames();
            ArrayList elementDtdNames = validatee.getElementDtdNames();
            int noOfElements = elementNames.size();
            String elementName = null;
            String elementDtdName = null;
            boolean count = false;
            for (int i = 0; i < noOfElements; ++i) {
                elementName = (String)elementNames.get(i);
                elementDtdName = (String)elementDtdNames.get(i);
                failures.addAll(this.validateCardinalConstraint(validatee, elementName, elementDtdName));
                boolean isBean = validatee.isBeanElement(elementName);
                if (isBean) {
                    failures.addAll(this.recurse(elementName, validatee));
                    continue;
                }
                Validator validator = this.getValidator(xpath);
                if (null == validator) continue;
                failures.addAll(validator.validate(elementName, elementDtdName, validatee));
            }
        }
        return failures;
    }

    public Collection validateIndividualProperty(String property, String absoluteDtdName, String fieldName) {
        ArrayList failures = new ArrayList();
        String xpath = this.utils.getParentName(absoluteDtdName, 47);
        Validator validator = this.getValidator(xpath);
        if (null != validator) {
            failures.addAll(validator.validateIndividualProperty(property, absoluteDtdName, fieldName));
        }
        return failures;
    }

    private Collection recurse(String elementName, Validatee validatee) {
        ArrayList failures = new ArrayList();
        boolean isIndexed = validatee.isIndexed(elementName);
        if (isIndexed) {
            failures.addAll(this.validateBeans(elementName, validatee));
        } else {
            failures.addAll(this.validateBean(elementName, validatee));
        }
        return failures;
    }

    private Collection validateCardinalConstraint(Validatee validatee, String elementName, String elementDtdName) {
        ArrayList failures = new ArrayList();
        int cardinal = validatee.getElementCardinal(elementName);
        CardinalConstraint constraint = this.getCardinalConstraint(cardinal);
        switch (cardinal) {
            case 48: 
            case 64: {
                Object[] elements = validatee.getElements(elementName);
                String name = validatee.getIndexedXPath() + "/" + elementDtdName;
                failures.addAll(constraint.match(elements, name));
                break;
            }
            case 16: {
                Object element = validatee.getElement(elementName);
                break;
            }
            default: {
                Object element = validatee.getElement(elementName);
                String name = validatee.getIndexedXPath() + "/" + elementDtdName;
                failures.addAll(constraint.match(element, name));
            }
        }
        return failures;
    }

    private Validator getValidator(String xpath) {
        Validator validator = null;
        if (null == this.xpathToValidator) {
            this.constructXpathToValidator();
        }
        if (null != this.xpathToValidator) {
            validator = (Validator)this.xpathToValidator.get(xpath);
        }
        return validator;
    }

    private void constructXpathToValidator() {
        if (null == this.validation) {
            this.constructValidation();
        }
        if (null == this.validation) {
            String format = BundleReader.getValue("Warning_Not_available");
            Object[] arguments = new Object[]{"Validation Data"};
            System.out.println(MessageFormat.format(format, arguments));
            return;
        }
        this.xpathToValidator = new HashMap();
        int noOfElements = this.validation.sizeElement();
        Element element = null;
        Validator validator = null;
        String elementName = null;
        String beanName = null;
        Check check = null;
        Object checkName = null;
        for (int i = 0; i < noOfElements; ++i) {
            element = this.validation.getElement(i);
            elementName = this.utils.getName(element.getName(), 47);
            beanName = this.utils.getParentName(element.getName(), 47);
            validator = (Validator)this.xpathToValidator.get(beanName);
            if (null == validator) {
                validator = new Validator();
                this.xpathToValidator.put(beanName, validator);
            }
            int noOfChecks = element.sizeCheck();
            Constraint constraint = null;
            for (int j = 0; j < noOfChecks; ++j) {
                check = element.getCheck(j);
                constraint = this.getConstraint(check);
                if (null == constraint) continue;
                validator.addElementConstraint(elementName, constraint);
            }
        }
    }

    private void constructValidation() {
        Object url = null;
        InputStream inputStream = null;
        if (this.validationFile != null) {
            inputStream = this.getInputStream(this.validationFile);
            if (inputStream == null) {
                String format = BundleReader.getValue("MSG_using_the_default_file");
                Object[] arguments = new Object[]{this.defaultValidationFile};
                System.out.println(MessageFormat.format(format, arguments));
                inputStream = this.getDafaultStream();
            }
        } else {
            inputStream = this.getDafaultStream();
        }
        if (inputStream != null) {
            try {
                this.validation = Validation.createGraph(inputStream);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                this.validation = null;
            }
        }
    }

    private Constraint getConstraint(Check check) {
        Constraint constraint = null;
        if (null == this.constraints) {
            this.constructConstraints();
        }
        CheckInfo checkInfo = null;
        if (null != this.constraints) {
            String checkName = check.getName();
            checkInfo = this.getCheckInfo(checkName, this.constraints);
            if (null != checkInfo) {
                constraint = this.buildConstraint(check, checkInfo);
            } else {
                String format = BundleReader.getValue("MSG_No_definition_for");
                Object[] arguments = new Object[]{"CheckInfo", checkName};
                System.out.println(MessageFormat.format(format, arguments));
            }
        } else {
            String format = BundleReader.getValue("MSG_Not_defined");
            Object[] arguments = new Object[]{"Constraints"};
            System.out.println(MessageFormat.format(format, arguments));
        }
        return constraint;
    }

    private void constructConstraints() {
        Constraints customConstraints = null;
        Constraints defaultConstraints = null;
        String constraintsFile = System.getProperty("constraints.file");
        if (constraintsFile != null) {
            customConstraints = this.getConstraints(constraintsFile);
        }
        if (defaultConstraintsFile != null) {
            defaultConstraints = this.getConstraints(defaultConstraintsFile);
        }
        if (customConstraints != null) {
            if (defaultConstraints != null) {
                int count = defaultConstraints.sizeCheckInfo();
                CheckInfo checkInfo = null;
                CheckInfo checkInfoClone = null;
                for (int i = 0; i < count; ++i) {
                    checkInfo = defaultConstraints.getCheckInfo(i);
                    checkInfoClone = (CheckInfo)((Object)checkInfo.clone());
                    customConstraints.addCheckInfo(checkInfoClone);
                }
                this.constraints = customConstraints;
            } else {
                this.constraints = customConstraints;
            }
        } else {
            this.constraints = defaultConstraints;
        }
    }

    private CheckInfo getCheckInfo(String checkName, Constraints constraints) {
        CheckInfo checkInfo = null;
        int size = constraints.sizeCheckInfo();
        for (int i = 0; i < size; ++i) {
            checkInfo = constraints.getCheckInfo(i);
            if (!checkName.equals(checkInfo.getName())) continue;
            return checkInfo;
        }
        return null;
    }

    private Constraint buildConstraint(Check check, CheckInfo checkInfo) {
        Constraint constraint = null;
        String classname = checkInfo.getClassname();
        Arguments arguments = checkInfo.getArguments();
        Class[] argumentTypeClass = new Class[1];
        Object[] argumentValue = new Object[1];
        constraint = (Constraint)this.utils.createObject(classname);
        if (null != arguments) {
            int size = arguments.sizeArgument();
            Parameters parameters = check.getParameters();
            if (null != parameters && size == parameters.sizeParameter()) {
                Argument argument = null;
                Parameter parameter = null;
                for (int i = 0; i < size; ++i) {
                    argument = arguments.getArgument(i);
                    String argumentName = argument.getName();
                    String argumentType = argument.getType();
                    parameter = this.getParameter(parameters, argumentName);
                    if (parameter == null) {
                        String format = BundleReader.getValue("Warning_no_value_specified_for");
                        Object[] substitutes = new Object[]{argumentName, check.getName()};
                        System.out.println(MessageFormat.format(format, substitutes));
                        continue;
                    }
                    if (null == argumentType) {
                        argumentType = "java.lang.String";
                    }
                    int noOfValues = 1;
                    if (argumentType.equals("java.lang.String[]")) {
                        Integer sz = (Integer)this.utils.getElement("value", (Object)parameter, SIZE_PREFIX);
                        noOfValues = sz;
                        argumentType = "java.lang.String";
                    }
                    for (int j = 0; j < noOfValues; ++j) {
                        argumentValue[0] = this.utils.getElement("value", j, (Object)parameter);
                        argumentTypeClass[0] = this.utils.getClass(argumentType);
                        String methodName = this.utils.methodNameFromDtdName(argumentName, SET_PREFIX);
                        Method method = this.utils.getMethod(this.utils.getClass(constraint), methodName, argumentTypeClass);
                        this.utils.invoke(constraint, method, argumentValue);
                    }
                }
            } else {
                String format = BundleReader.getValue("MSG_Conflicting_Constraint_information");
                Object[] substitues = new Object[]{check.getName()};
                String message = MessageFormat.format(format, substitues);
                assert (false) : message;
            }
        }
        return constraint;
    }

    private CardinalConstraint getCardinalConstraint(int cardinal) {
        Class[] argumentTypes = new Class[]{Integer.TYPE};
        Constructor constructor = this.utils.getConstructor(CARDINAL_CONSTRAINT_CLASS, argumentTypes);
        Integer parameter = cardinal;
        Object[] argumentValues = new Object[]{parameter};
        return (CardinalConstraint)this.utils.createObject(constructor, argumentValues);
    }

    private Collection validateBeans(String elementName, Validatee validatee) {
        int noOfElements = 0;
        String sizeMethodName = this.utils.methodNameFromBeanName(elementName, SIZE_PREFIX);
        Method sizeMethod = validatee.getMethod(sizeMethodName);
        noOfElements = (Integer)validatee.invoke(sizeMethod);
        ArrayList failures = new ArrayList();
        Object child = null;
        for (int i = 0; i < noOfElements; ++i) {
            child = validatee.getElement(elementName, i);
            if (child == null) continue;
            failures.addAll(this.validate(child));
        }
        return failures;
    }

    private Collection validateBean(String elementName, Validatee validatee) {
        ArrayList failures = new ArrayList();
        Object child = null;
        child = validatee.getElement(elementName);
        if (child != null) {
            failures.addAll(this.validate(child));
        }
        return failures;
    }

    private InputStream getDafaultStream() {
        InputStream inputStream = null;
        URL url = null;
        if (this.defaultValidationFile != null) {
            url = this.utils.getUrlObject(this.defaultValidationFile);
            if (url != null) {
                try {
                    inputStream = url.openStream();
                }
                catch (IOException exception) {
                    System.out.println(exception.getMessage());
                }
            } else {
                assert (false) : BundleReader.getValue("Error_control_should_never_reach_here");
                String format = BundleReader.getValue("Error_can_not_access_file");
                Object[] arguments = new Object[]{this.defaultValidationFile};
                String message = MessageFormat.format(format, arguments);
                assert (false) : message;
            }
        } else assert (false) : BundleReader.getValue("Error_control_should_never_reach_here");
        return inputStream;
    }

    private Parameter getParameter(Parameters parameters, String name) {
        int size = parameters.sizeParameter();
        Parameter returnValue = null;
        Parameter parameter = null;
        String parameterName = null;
        for (int i = 0; i < size; ++i) {
            parameter = (Parameter)((Object)this.utils.getElement("parameter", i, (Object)parameters));
            parameterName = parameter.getName();
            if (!parameterName.equals(name)) continue;
            returnValue = parameter;
            break;
        }
        return returnValue;
    }

    private InputStream getInputStream(String inputFile) {
        InputStream inputStream = null;
        if (inputFile.lastIndexOf(58) == -1) {
            URL url = null;
            url = this.utils.getUrlObject(inputFile);
            if (url != null) {
                try {
                    inputStream = url.openStream();
                }
                catch (IOException exception) {
                    System.out.println(exception.getMessage());
                }
            } else {
                String format = BundleReader.getValue("Error_specified_file_can_not_be_used");
                Object[] arguments = new Object[]{inputFile};
                System.out.println(MessageFormat.format(format, arguments));
            }
        } else {
            File file = new File(inputFile);
            if (file.exists()) {
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException exception) {
                    System.out.println(exception.getMessage());
                    inputStream = null;
                }
            } else {
                String format = BundleReader.getValue("Error_specified_file_can_not_be_used");
                Object[] arguments = new Object[]{inputFile};
                System.out.println(MessageFormat.format(format, arguments));
            }
        }
        return inputStream;
    }

    private String getValidateeImplementation(Object object, String propertiesFile) {
        String returnVal = null;
        Class classObject = this.utils.getClass(object);
        String className = classObject.getName();
        BundleReader.setBundle(propertiesFile);
        String validateeImplName = BundleReader.getValue(className);
        while (!className.equals("java.lang.Object")) {
            if (!validateeImplName.equals(className)) {
                returnVal = validateeImplName;
                break;
            }
            classObject = classObject.getSuperclass();
            className = classObject.getName();
            validateeImplName = BundleReader.getValue(className);
        }
        return returnVal;
    }

    private Constraints getConstraints(String constraintsFile) {
        Object url = null;
        InputStream inputStream = null;
        Constraints retVal = null;
        if (constraintsFile != null) {
            inputStream = this.getInputStream(constraintsFile);
        }
        if (inputStream != null) {
            try {
                retVal = Constraints.createGraph(inputStream);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                retVal = null;
            }
        }
        return retVal;
    }
}

