/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.instrument.metrics.AbstractSimpleMetricExt;
import org.logstash.instrument.metrics.NamespacedMetricExt;

@JRubyClass(name={"Metric"})
public final class MetricExt
extends AbstractSimpleMetricExt {
    private static final long serialVersionUID = 1L;
    public static final RubySymbol COUNTER = RubyUtil.RUBY.newSymbol("counter");
    private static final RubyFixnum ONE = RubyUtil.RUBY.newFixnum(1);
    private static final RubySymbol INCREMENT = RubyUtil.RUBY.newSymbol("increment");
    private static final RubySymbol DECREMENT = RubyUtil.RUBY.newSymbol("decrement");
    private static final RubySymbol GAUGE = RubyUtil.RUBY.newSymbol("gauge");
    private static final RubySymbol SET = RubyUtil.RUBY.newSymbol("set");
    private IRubyObject collector;

    public MetricExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"validate_key!"}, meta=true)
    public static IRubyObject validateKey(ThreadContext context, IRubyObject recv, IRubyObject key) {
        MetricExt.validateName(context, key, RubyUtil.METRIC_NO_KEY_PROVIDED_CLASS);
        return context.nil;
    }

    public static void validateName(ThreadContext context, IRubyObject key, RubyClass exception) {
        if (key.isNil() || key instanceof RubySymbol && ((RubySymbol)key).empty_p(context).isTrue() || key instanceof RubyString && ((RubyString)key).isEmpty()) {
            throw context.runtime.newRaiseException(exception, null);
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject collector) {
        this.collector = collector;
        return this;
    }

    public IRubyObject increment(ThreadContext context, IRubyObject namespace, IRubyObject key) {
        return this.increment(context, namespace, key, (IRubyObject)ONE);
    }

    public IRubyObject increment(ThreadContext context, IRubyObject namespace, IRubyObject key, IRubyObject value) {
        MetricExt.validateKey(context, null, key);
        return this.collector.callMethod(context, "push", new IRubyObject[]{namespace, key, COUNTER, INCREMENT, value});
    }

    public IRubyObject decrement(ThreadContext context, IRubyObject namespace, IRubyObject key) {
        return this.decrement(context, namespace, key, (IRubyObject)ONE);
    }

    public IRubyObject decrement(ThreadContext context, IRubyObject namespace, IRubyObject key, IRubyObject value) {
        MetricExt.validateKey(context, null, key);
        return this.collector.callMethod(context, "push", new IRubyObject[]{namespace, key, COUNTER, DECREMENT, value});
    }

    @Override
    protected IRubyObject doDecrement(ThreadContext context, IRubyObject[] args) {
        if (args.length == 2) {
            return this.decrement(context, args[0], args[1], (IRubyObject)ONE);
        }
        return this.decrement(context, args[0], args[1], args[2]);
    }

    @Override
    protected IRubyObject getCollector(ThreadContext context) {
        return this.collector;
    }

    @Override
    protected IRubyObject doIncrement(ThreadContext context, IRubyObject[] args) {
        if (args.length == 2) {
            return this.increment(context, args[0], args[1]);
        }
        return this.increment(context, args[0], args[1], args[2]);
    }

    @Override
    protected IRubyObject getGauge(ThreadContext context, IRubyObject namespace, IRubyObject key, IRubyObject value) {
        MetricExt.validateKey(context, null, key);
        return this.collector.callMethod(context, "push", new IRubyObject[]{namespace, key, GAUGE, SET, value});
    }

    @Override
    protected IRubyObject doReportTime(ThreadContext context, IRubyObject namespace, IRubyObject key, IRubyObject duration) {
        MetricExt.validateKey(context, null, key);
        return this.collector.callMethod(context, "push", new IRubyObject[]{namespace, key, COUNTER, INCREMENT, duration});
    }

    @Override
    protected IRubyObject doTime(ThreadContext context, IRubyObject namespace, IRubyObject key, Block block) {
        MetricExt.validateKey(context, null, key);
        if (!block.isGiven()) {
            return TimedExecution.create(this, namespace, key);
        }
        long startTime = System.nanoTime();
        IRubyObject res = block.call(context);
        this.reportTime(context, namespace, key, (IRubyObject)RubyFixnum.newFixnum((Ruby)context.runtime, (long)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS)));
        return res;
    }

    @Override
    protected NamespacedMetricExt createNamespaced(ThreadContext context, IRubyObject name) {
        MetricExt.validateName(context, name, RubyUtil.METRIC_NO_NAMESPACE_PROVIDED_CLASS);
        return NamespacedMetricExt.create(this, name instanceof RubyArray ? (RubyArray)name : RubyArray.newArray((Ruby)context.runtime, (IRubyObject)name));
    }

    @JRubyClass(name={"MetricNoNamespaceProvided"}, parent="MetricException")
    public static final class MetricNoNamespaceProvided
    extends MetricException {
        private static final long serialVersionUID = 1L;

        public MetricNoNamespaceProvided(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }
    }

    @JRubyClass(name={"MetricNoBlockProvided"}, parent="MetricException")
    public static final class MetricNoBlockProvided
    extends MetricException {
        private static final long serialVersionUID = 1L;

        public MetricNoBlockProvided(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }
    }

    @JRubyClass(name={"MetricNoKeyProvided"}, parent="MetricException")
    public static final class MetricNoKeyProvided
    extends MetricException {
        private static final long serialVersionUID = 1L;

        public MetricNoKeyProvided(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }
    }

    @JRubyClass(name={"MetricException"})
    public static class MetricException
    extends RubyException {
        private static final long serialVersionUID = 1L;

        public MetricException(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }
    }

    @JRubyClass(name={"TimedExecution"})
    public static final class TimedExecution
    extends RubyObject {
        private static final long serialVersionUID = 1L;
        private final long startTime = System.nanoTime();
        private MetricExt metric;
        private IRubyObject namespace;
        private IRubyObject key;

        public static TimedExecution create(MetricExt metric, IRubyObject namespace, IRubyObject key) {
            TimedExecution res = new TimedExecution(RubyUtil.RUBY, RubyUtil.TIMED_EXECUTION_CLASS);
            res.metric = metric;
            res.namespace = namespace;
            res.key = key;
            return res;
        }

        @JRubyMethod
        public RubyFixnum stop(ThreadContext context) {
            RubyFixnum result = RubyFixnum.newFixnum((Ruby)context.runtime, (long)TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS));
            this.metric.reportTime(context, this.namespace, this.key, (IRubyObject)result);
            return result;
        }

        public TimedExecution(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }
    }
}

