/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.io.IOUtils;
import edu.berkeley.nlp.lm.io.LmReader;
import edu.berkeley.nlp.lm.io.LmReaderCallback;
import edu.berkeley.nlp.lm.util.Logger;
import edu.berkeley.nlp.lm.util.LongRef;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class TextReader<W>
implements LmReader<LongRef, LmReaderCallback<LongRef>> {
    private final WordIndexer<W> wordIndexer;
    private final Iterable<String> lineIterator;

    public TextReader(List<String> inputFiles, WordIndexer<W> wordIndexer) {
        this(TextReader.getLineIterator(inputFiles), wordIndexer);
    }

    public TextReader(Iterable<String> lineIterator, WordIndexer<W> wordIndexer) {
        this.lineIterator = lineIterator;
        this.wordIndexer = wordIndexer;
    }

    @Override
    public void parse(LmReaderCallback<LongRef> callback) {
        this.readFromFiles(callback);
    }

    private void readFromFiles(LmReaderCallback<LongRef> callback) {
        Logger.startTrack("Reading in ngrams from raw text", new Object[0]);
        this.countNgrams(this.lineIterator, callback);
        Logger.endTrack();
    }

    private void countNgrams(Iterable<String> allLinesIterator, LmReaderCallback<LongRef> callback) {
        long numLines = 0L;
        for (String line : allLinesIterator) {
            if (numLines % 10000L == 0L) {
                Logger.logs("On line " + numLines);
            }
            ++numLines;
            String[] words = line.split(" ");
            int[] sent = new int[words.length + 2];
            sent[0] = this.wordIndexer.getOrAddIndex(this.wordIndexer.getStartSymbol());
            sent[sent.length - 1] = this.wordIndexer.getOrAddIndex(this.wordIndexer.getEndSymbol());
            for (int i = 0; i < words.length; ++i) {
                sent[i + 1] = this.wordIndexer.getOrAddIndexFromString(words[i]);
            }
            callback.call(sent, 0, sent.length, new LongRef(1L), line);
        }
        callback.cleanup();
    }

    private static Iterable<String> getLineIterator(Iterable<String> files) {
        Iterable<String> allLinesIterator = Iterators.flatten(new Iterators.Transform<String, Iterator<String>>(files.iterator()){

            @Override
            protected Iterator<String> transform(String file) {
                try {
                    if (file.equals("-")) {
                        return IOUtils.lineIterator(IOUtils.getReader(System.in));
                    }
                    return IOUtils.lineIterator(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return allLinesIterator;
    }
}

