/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import com.android.dx.rop.code.AccessFlags;

public class AccessInfo {
    public static final int VISIBILITY_FLAGS = 7;
    private final int accFlags;
    private final AFType type;

    public AccessInfo(int accessFlags, AFType type) {
        this.accFlags = accessFlags;
        this.type = type;
    }

    public boolean containsFlag(int flag) {
        return (this.accFlags & flag) != 0;
    }

    public AccessInfo remove(int flag) {
        if (this.containsFlag(flag)) {
            return new AccessInfo(this.accFlags & ~flag, this.type);
        }
        return this;
    }

    public AccessInfo add(int flag) {
        if (!this.containsFlag(flag)) {
            return new AccessInfo(this.accFlags | flag, this.type);
        }
        return this;
    }

    public AccessInfo changeVisibility(int flag) {
        int currentVisFlags = this.accFlags & 7;
        if (currentVisFlags == flag) {
            return this;
        }
        int unsetAllVisFlags = this.accFlags & 0xFFFFFFF8;
        return new AccessInfo(unsetAllVisFlags | flag, this.type);
    }

    public AccessInfo getVisibility() {
        return new AccessInfo(this.accFlags & 7, this.type);
    }

    public boolean isPublic() {
        return (this.accFlags & 1) != 0;
    }

    public boolean isProtected() {
        return (this.accFlags & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.accFlags & 2) != 0;
    }

    public boolean isAbstract() {
        return (this.accFlags & 0x400) != 0;
    }

    public boolean isInterface() {
        return (this.accFlags & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.accFlags & 0x2000) != 0;
    }

    public boolean isNative() {
        return (this.accFlags & 0x100) != 0;
    }

    public boolean isStatic() {
        return (this.accFlags & 8) != 0;
    }

    public boolean isFinal() {
        return (this.accFlags & 0x10) != 0;
    }

    public boolean isConstructor() {
        return (this.accFlags & 0x10000) != 0;
    }

    public boolean isEnum() {
        return (this.accFlags & 0x4000) != 0;
    }

    public boolean isSynthetic() {
        return (this.accFlags & 0x1000) != 0;
    }

    public boolean isBridge() {
        return (this.accFlags & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.accFlags & 0x80) != 0;
    }

    public boolean isSynchronized() {
        return (this.accFlags & 0x20020) != 0;
    }

    public boolean isTransient() {
        return (this.accFlags & 0x80) != 0;
    }

    public boolean isVolatile() {
        return (this.accFlags & 0x40) != 0;
    }

    public AFType getType() {
        return this.type;
    }

    public String makeString() {
        StringBuilder code = new StringBuilder();
        if (this.isPublic()) {
            code.append("public ");
        }
        if (this.isPrivate()) {
            code.append("private ");
        }
        if (this.isProtected()) {
            code.append("protected ");
        }
        if (this.isStatic()) {
            code.append("static ");
        }
        if (this.isFinal()) {
            code.append("final ");
        }
        if (this.isAbstract()) {
            code.append("abstract ");
        }
        if (this.isNative()) {
            code.append("native ");
        }
        switch (this.type) {
            case METHOD: {
                if (this.isSynchronized()) {
                    code.append("synchronized ");
                }
                if (!this.isBridge()) break;
                code.append("/* bridge */ ");
                break;
            }
            case FIELD: {
                if (this.isVolatile()) {
                    code.append("volatile ");
                }
                if (!this.isTransient()) break;
                code.append("transient ");
                break;
            }
            case CLASS: {
                if ((this.accFlags & 0x800) == 0) break;
                code.append("strict ");
            }
        }
        if (this.isSynthetic()) {
            code.append("/* synthetic */ ");
        }
        return code.toString();
    }

    public String rawString() {
        switch (this.type) {
            case CLASS: {
                return AccessFlags.classString((int)this.accFlags);
            }
            case FIELD: {
                return AccessFlags.fieldString((int)this.accFlags);
            }
            case METHOD: {
                return AccessFlags.methodString((int)this.accFlags);
            }
        }
        return "?";
    }

    public String toString() {
        return "AccessInfo: " + (Object)((Object)this.type) + " 0x" + Integer.toHexString(this.accFlags) + " (" + this.rawString() + ")";
    }

    public static enum AFType {
        CLASS,
        FIELD,
        METHOD;

    }
}

