/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.grails.datastore.mapping.collection.AbstractPersistentCollection;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.AssociationQueryExecutor;
import org.grails.datastore.mapping.model.types.Association;

public class PersistentList
extends AbstractPersistentCollection
implements List {
    private final List list;

    public PersistentList(Class childType, Session session, List collection) {
        super(childType, session, collection);
        this.list = collection;
    }

    public PersistentList(Collection keys, Class childType, Session session) {
        super(keys, childType, session, new ArrayList());
        this.list = (List)this.collection;
    }

    public PersistentList(Serializable associationKey, Session session, AssociationQueryExecutor indexer) {
        super(associationKey, session, indexer, new ArrayList());
        this.list = (List)this.collection;
    }

    public PersistentList(Association association, Serializable associationKey, Session session) {
        super(association, associationKey, session, new ArrayList());
        this.list = (List)this.collection;
    }

    @Override
    public int indexOf(Object o) {
        this.initialize();
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.initialize();
        return this.list.lastIndexOf(o);
    }

    public Object get(int index) {
        this.initialize();
        return this.list.get(index);
    }

    public Object set(int index, Object element) {
        this.initialize();
        Object replaced = this.list.set(index, element);
        if (replaced != element) {
            this.markDirty();
        }
        return replaced;
    }

    public void add(int index, Object element) {
        this.initialize();
        this.list.add(index, element);
        this.markDirty();
    }

    public Object remove(int index) {
        this.initialize();
        int size = this.size();
        Object removed = this.list.remove(index);
        if (size != this.size()) {
            this.markDirty();
        }
        return removed;
    }

    public boolean addAll(int index, Collection c) {
        this.initialize();
        boolean changed = this.list.addAll(index, c);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    public ListIterator listIterator() {
        this.initialize();
        return new PersistentListIterator(this.list.listIterator());
    }

    public ListIterator listIterator(int index) {
        this.initialize();
        return new PersistentListIterator(this.list.listIterator(index));
    }

    public List subList(int fromIndex, int toIndex) {
        this.initialize();
        return this.list.subList(fromIndex, toIndex);
    }

    private class PersistentListIterator
    implements ListIterator {
        private final ListIterator iterator;

        private PersistentListIterator(ListIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            PersistentList.this.markDirty();
        }

        public void set(Object e) {
            this.iterator.set(e);
            PersistentList.this.markDirty();
        }

        public void add(Object e) {
            this.iterator.add(e);
            PersistentList.this.markDirty();
        }
    }
}

