/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class RestMultiSearchAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestMultiSearchAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi search requests is deprecated.";
    private static final Set<String> RESPONSE_PARAMS;
    private final boolean allowExplicitIndex;

    public RestMultiSearchAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/_msearch", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_msearch", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_msearch", this);
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public String getName() {
        return "msearch_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchRequest multiSearchRequest = RestMultiSearchAction.parseRequest(request, this.allowExplicitIndex);
        for (SearchRequest searchRequest : multiSearchRequest.requests()) {
            if (searchRequest.types().length <= 0) continue;
            deprecationLogger.deprecatedAndMaybeLog("msearch_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            break;
        }
        return channel -> client.multiSearch(multiSearchRequest, new RestToXContentListener<MultiSearchResponse>((RestChannel)channel));
    }

    public static MultiSearchRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex) throws IOException {
        MultiSearchRequest multiRequest = new MultiSearchRequest();
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(restRequest, multiRequest.indicesOptions());
        multiRequest.indicesOptions(indicesOptions);
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        int preFilterShardSize = restRequest.paramAsInt("pre_filter_shard_size", 128);
        Integer maxConcurrentShardRequests = restRequest.hasParam("max_concurrent_shard_requests") ? Integer.valueOf(restRequest.paramAsInt("max_concurrent_shard_requests", Integer.MIN_VALUE)) : null;
        RestMultiSearchAction.parseMultiLineRequest(restRequest, multiRequest.indicesOptions(), allowExplicitIndex, (searchRequest, parser) -> {
            searchRequest.source(SearchSourceBuilder.fromXContent(parser, false));
            RestSearchAction.checkRestTotalHits(restRequest, searchRequest);
            multiRequest.add((SearchRequest)searchRequest);
        });
        List<SearchRequest> requests = multiRequest.requests();
        preFilterShardSize = Math.max(1, preFilterShardSize / (requests.size() + 1));
        for (SearchRequest request : requests) {
            request.setPreFilterShardSize(Math.min(preFilterShardSize, request.getPreFilterShardSize()));
            if (maxConcurrentShardRequests == null) continue;
            request.setMaxConcurrentShardRequests(maxConcurrentShardRequests);
        }
        return multiRequest;
    }

    public static void parseMultiLineRequest(RestRequest request, IndicesOptions indicesOptions, boolean allowExplicitIndex, CheckedBiConsumer<SearchRequest, XContentParser, IOException> consumer) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] types = Strings.splitStringByCommaToArray(request.param("type"));
        String searchType = request.param("search_type");
        boolean ccsMinimizeRoundtrips = request.paramAsBoolean("ccs_minimize_roundtrips", true);
        String routing = request.param("routing");
        Tuple<XContentType, BytesReference> sourceTuple = request.contentOrSourceParam();
        XContent xContent = ((XContentType)sourceTuple.v1()).xContent();
        BytesReference data = (BytesReference)sourceTuple.v2();
        MultiSearchRequest.readMultiLineFormat(data, xContent, consumer, indices, indicesOptions, types, routing, searchType, ccsMinimizeRoundtrips, request.getXContentRegistry(), allowExplicitIndex);
    }

    @Override
    public boolean supportsContentStream() {
        return true;
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

