/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ICache;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

@ConfinedToDsfExecutor(value="fExecutor")
public abstract class AbstractCache<V>
implements ICache<V> {
    private static final IStatus INVALID_STATUS = new Status(4, "org.eclipse.cdt.dsf", 10001, "Cache invalid", null);
    private RequestCanceledListener fRequestCanceledListener = new RequestCanceledListener();
    private boolean fValid;
    private V fData;
    private IStatus fStatus = INVALID_STATUS;
    @ThreadSafe
    private Object fWaitingList;
    private final ImmediateInDsfExecutor fExecutor;

    public AbstractCache(ImmediateInDsfExecutor executor) {
        this.fExecutor = executor;
    }

    @Override
    public DsfExecutor getExecutor() {
        return this.fExecutor.getDsfExecutor();
    }

    protected ImmediateInDsfExecutor getImmediateInDsfExecutor() {
        return this.fExecutor;
    }

    protected abstract void retrieve();

    @ThreadSafe
    protected abstract void canceled();

    @Override
    public boolean isValid() {
        return this.fValid;
    }

    @Override
    public V getData() {
        if (!this.fValid) {
            throw new IllegalStateException("Cache is not valid.  Cache data can be read only when cache is valid.");
        }
        return this.fData;
    }

    @Override
    public IStatus getStatus() {
        if (!this.fValid) {
            throw new IllegalStateException("Cache is not valid.  Cache status can be read only when cache is valid.");
        }
        return this.fStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(RequestMonitor rm) {
        assert (this.fExecutor.getDsfExecutor().isInExecutorThread());
        if (!this.fValid) {
            boolean first = false;
            AbstractCache abstractCache = this;
            synchronized (abstractCache) {
                if (this.fWaitingList == null) {
                    first = true;
                    this.fWaitingList = rm;
                } else if (this.fWaitingList instanceof RequestMonitor[]) {
                    RequestMonitor[] waitingList = (RequestMonitor[])this.fWaitingList;
                    int waitingListLength = waitingList.length;
                    int i = 0;
                    while (i < waitingListLength) {
                        if (waitingList[i] == null) {
                            waitingList[i] = rm;
                            break;
                        }
                        ++i;
                    }
                    if (i == waitingListLength) {
                        RequestMonitor[] newWaitingList = new RequestMonitor[waitingListLength + 1];
                        System.arraycopy(waitingList, 0, newWaitingList, 0, waitingListLength);
                        newWaitingList[waitingListLength] = rm;
                        this.fWaitingList = newWaitingList;
                    }
                } else {
                    RequestMonitor[] newWaitingList = new RequestMonitor[]{(RequestMonitor)this.fWaitingList, rm};
                    this.fWaitingList = newWaitingList;
                }
            }
            rm.addCancelListener(this.fRequestCanceledListener);
            if (first) {
                this.retrieve();
            }
        } else {
            rm.setStatus(this.fStatus);
            rm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeWaitingRms() {
        Object waiting = null;
        AbstractCache abstractCache = this;
        synchronized (abstractCache) {
            waiting = this.fWaitingList;
            this.fWaitingList = null;
        }
        if (waiting != null) {
            if (waiting instanceof RequestMonitor) {
                this.completeWaitingRm((RequestMonitor)waiting);
            } else if (waiting instanceof RequestMonitor[]) {
                RequestMonitor[] waitingList = (RequestMonitor[])waiting;
                int i = 0;
                while (i < waitingList.length) {
                    if (waitingList[i] != null) {
                        this.completeWaitingRm(waitingList[i]);
                    }
                    ++i;
                }
            }
            waiting = null;
        }
    }

    private void completeWaitingRm(RequestMonitor rm) {
        rm.setStatus(this.fStatus);
        rm.removeCancelListener(this.fRequestCanceledListener);
        rm.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCanceledRm(RequestMonitor rm) {
        boolean found = false;
        boolean waiting = false;
        AbstractCache abstractCache = this;
        synchronized (abstractCache) {
            if (rm.equals(this.fWaitingList)) {
                found = true;
                waiting = false;
                this.fWaitingList = null;
            } else if (this.fWaitingList instanceof RequestMonitor[]) {
                RequestMonitor[] waitingList = (RequestMonitor[])this.fWaitingList;
                int i = 0;
                while (i < waitingList.length) {
                    if (!found && rm.equals(waitingList[i])) {
                        waitingList[i] = null;
                        found = true;
                    }
                    waiting = waiting || waitingList[i] != null;
                    ++i;
                }
            }
            if (found && !waiting) {
                this.canceled();
            }
        }
        if (found) {
            rm.removeCancelListener(this.fRequestCanceledListener);
            rm.setStatus(Status.CANCEL_STATUS);
            rm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    protected boolean isCanceled() {
        boolean canceled;
        ArrayList<RequestMonitor> canceledRms = null;
        AbstractCache abstractCache = this;
        synchronized (abstractCache) {
            if (this.fWaitingList instanceof RequestMonitor) {
                if (((RequestMonitor)this.fWaitingList).isCanceled()) {
                    canceledRms = new ArrayList<RequestMonitor>(1);
                    canceledRms.add((RequestMonitor)this.fWaitingList);
                    canceled = true;
                } else {
                    canceled = false;
                }
            } else if (this.fWaitingList instanceof RequestMonitor[]) {
                canceled = true;
                RequestMonitor[] waitingList = (RequestMonitor[])this.fWaitingList;
                int i = 0;
                while (i < waitingList.length) {
                    if (waitingList[i] != null) {
                        if (waitingList[i].isCanceled()) {
                            if (canceledRms == null) {
                                canceledRms = new ArrayList(1);
                            }
                            canceledRms.add(waitingList[i]);
                        } else {
                            canceled = false;
                        }
                    }
                    ++i;
                }
            } else {
                assert (this.fWaitingList == null);
                canceled = true;
            }
        }
        if (canceledRms != null) {
            final ArrayList<RequestMonitor> _canceledRms = canceledRms;
            this.fExecutor.getDsfExecutor().execute(new DsfRunnable(){

                @Override
                public void run() {
                    for (RequestMonitor canceledRm : _canceledRms) {
                        AbstractCache.this.handleCanceledRm(canceledRm);
                    }
                }
            });
        }
        return canceled;
    }

    protected void reset() {
        if (!this.fValid) {
            throw new IllegalStateException("Cache is not valid.  Cache can be reset only when it's in a valid state");
        }
        this.fValid = false;
        this.fData = null;
        this.fStatus = INVALID_STATUS;
    }

    protected void set(V data, IStatus status) {
        assert (this.fExecutor.getDsfExecutor().isInExecutorThread());
        this.fData = data;
        this.fStatus = status;
        this.fValid = true;
        this.completeWaitingRms();
    }

    protected void setAndReset(V data, IStatus status) {
        assert (this.fExecutor.getDsfExecutor().isInExecutorThread());
        this.fData = data;
        this.fStatus = status;
        this.fValid = false;
        this.completeWaitingRms();
    }

    private class RequestCanceledListener
    implements RequestMonitor.ICanceledListener {
        private RequestCanceledListener() {
        }

        @Override
        public void requestCanceled(final RequestMonitor canceledRm) {
            AbstractCache.this.fExecutor.getDsfExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractCache.this.handleCanceledRm(canceledRm);
                }
            });
        }
    }
}

